/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

final class StackWalkUtil {
    private StackWalkUtil() {
    }

    static StackTraceElement[] stackWalkArray(Object[] a2) {
        return (StackTraceElement[])a2;
    }

    static Object stackWalkGetMethod(Class<?> after) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i2 = 3; i2 < stackTrace.length; ++i2) {
            if (stackTrace[i2].getClassName().startsWith(after.getName())) continue;
            return stackTrace[i2];
        }
        throw new IllegalStateException();
    }

    private static boolean isSameMethod(StackTraceElement a2, StackTraceElement b2) {
        return StackWalkUtil.isSameMethod(a2, b2, b2.getMethodName());
    }

    private static boolean isSameMethod(StackTraceElement a2, StackTraceElement b2, String methodName) {
        return a2.getMethodName().equals(methodName) && a2.getClassName().equals(b2.getClassName()) && Objects.equals(a2.getFileName(), b2.getFileName());
    }

    private static boolean isAutoCloseable(StackTraceElement element, StackTraceElement pushed) {
        if (StackWalkUtil.isSameMethod(element, pushed, "$closeResource")) {
            return true;
        }
        return "closeFinally".equals(element.getMethodName()) && "AutoCloseable.kt".equals(element.getFileName());
    }

    @Nullable
    static Object stackWalkCheckPop(Class<?> after, Object pushedObj) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i2 = 3; i2 < stackTrace.length; ++i2) {
            StackTraceElement element = stackTrace[i2];
            if (element.getClassName().startsWith(after.getName())) continue;
            StackTraceElement pushed = (StackTraceElement)pushedObj;
            if (StackWalkUtil.isSameMethod(element, pushed)) {
                return null;
            }
            if (StackWalkUtil.isAutoCloseable(element, pushed) && i2 + 1 < stackTrace.length) {
                element = stackTrace[i2 + 1];
                if (StackWalkUtil.isSameMethod(pushed, stackTrace[i2 + 1])) {
                    return null;
                }
            }
            return element;
        }
        throw new IllegalStateException();
    }

    static Object[] stackWalkGetTrace() {
        int i2;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (i2 = 3; i2 < stackTrace.length && stackTrace[i2].getClassName().startsWith("org.lwjgl.system.Memory"); ++i2) {
        }
        return Arrays.copyOfRange(stackTrace, i2, stackTrace.length);
    }
}

