/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

public class OutputBuffer {
    public static final int BUFFERSIZE = 2304;
    private static final int MAXCHANNELS = 2;
    private Float replayGainScale;
    private int channels;
    private byte[] buffer;
    private int[] channelPointer;
    private boolean isBigEndian;

    public OutputBuffer(int channels, boolean isBigEndian) {
        this.channels = channels;
        this.isBigEndian = isBigEndian;
        this.buffer = new byte[2304 * channels];
        this.channelPointer = new int[channels];
        this.reset();
    }

    private void append(int channel, short value) {
        byte secondByte;
        byte firstByte;
        if (this.isBigEndian) {
            firstByte = (byte)(value >>> 8 & 0xFF);
            secondByte = (byte)(value & 0xFF);
        } else {
            firstByte = (byte)(value & 0xFF);
            secondByte = (byte)(value >>> 8 & 0xFF);
        }
        this.buffer[this.channelPointer[channel]] = firstByte;
        this.buffer[this.channelPointer[channel] + 1] = secondByte;
        int n2 = channel;
        this.channelPointer[n2] = this.channelPointer[n2] + this.channels * 2;
    }

    public void appendSamples(int channel, float[] f2) {
        if (this.replayGainScale != null) {
            int i2 = 0;
            while (i2 < 32) {
                short s2 = this.clip(f2[i2++] * this.replayGainScale.floatValue());
                this.append(channel, s2);
            }
        } else {
            int i3 = 0;
            while (i3 < 32) {
                short s3 = this.clip(f2[i3++]);
                this.append(channel, s3);
            }
        }
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reset() {
        int n2;
        try {
            int index = this.channels - 1;
            n2 = this.channelPointer[index] - index * 2;
        }
        catch (Throwable throwable) {
            for (int i2 = 0; i2 < this.channels; ++i2) {
                this.channelPointer[i2] = i2 * 2;
            }
            throw throwable;
        }
        for (int i3 = 0; i3 < this.channels; ++i3) {
            this.channelPointer[i3] = i3 * 2;
        }
        return n2;
    }

    public void setReplayGainScale(Float replayGainScale) {
        this.replayGainScale = replayGainScale;
    }

    public boolean isStereo() {
        return this.channelPointer[1] == 2;
    }

    private final short clip(float sample) {
        return (short)(sample > 32767.0f ? Short.MAX_VALUE : (short)(sample < -32768.0f ? Short.MIN_VALUE : (short)sample));
    }
}

