/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.reflect;

import com.badlogic.gdx.utils.reflect.Annotation;
import com.badlogic.gdx.utils.reflect.Constructor;
import com.badlogic.gdx.utils.reflect.Field;
import com.badlogic.gdx.utils.reflect.Method;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.lang.reflect.Modifier;

public final class ClassReflection {
    public static Class forName(String name) throws ReflectionException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e2) {
            throw new ReflectionException("Class not found: " + name, e2);
        }
    }

    public static String getSimpleName(Class c2) {
        return c2.getSimpleName();
    }

    public static boolean isInstance(Class c2, Object obj) {
        return c2.isInstance(obj);
    }

    public static boolean isAssignableFrom(Class c1, Class c2) {
        return c1.isAssignableFrom(c2);
    }

    public static boolean isMemberClass(Class c2) {
        return c2.isMemberClass();
    }

    public static boolean isStaticClass(Class c2) {
        return Modifier.isStatic(c2.getModifiers());
    }

    public static boolean isArray(Class c2) {
        return c2.isArray();
    }

    public static boolean isPrimitive(Class c2) {
        return c2.isPrimitive();
    }

    public static boolean isEnum(Class c2) {
        return c2.isEnum();
    }

    public static boolean isAnnotation(Class c2) {
        return c2.isAnnotation();
    }

    public static boolean isInterface(Class c2) {
        return c2.isInterface();
    }

    public static boolean isAbstract(Class c2) {
        return Modifier.isAbstract(c2.getModifiers());
    }

    public static <T> T newInstance(Class<T> c2) throws ReflectionException {
        try {
            return c2.newInstance();
        }
        catch (InstantiationException e2) {
            throw new ReflectionException("Could not instantiate instance of class: " + c2.getName(), e2);
        }
        catch (IllegalAccessException e3) {
            throw new ReflectionException("Could not instantiate instance of class: " + c2.getName(), e3);
        }
    }

    public static Class getComponentType(Class c2) {
        return c2.getComponentType();
    }

    public static Constructor[] getConstructors(Class c2) {
        java.lang.reflect.Constructor<?>[] constructors = c2.getConstructors();
        Constructor[] result = new Constructor[constructors.length];
        int j2 = constructors.length;
        for (int i2 = 0; i2 < j2; ++i2) {
            result[i2] = new Constructor(constructors[i2]);
        }
        return result;
    }

    public static Constructor getConstructor(Class c2, Class ... parameterTypes) throws ReflectionException {
        try {
            return new Constructor(c2.getConstructor(parameterTypes));
        }
        catch (SecurityException e2) {
            throw new ReflectionException("Security violation occurred while getting constructor for class: '" + c2.getName() + "'.", e2);
        }
        catch (NoSuchMethodException e3) {
            throw new ReflectionException("Constructor not found for class: " + c2.getName(), e3);
        }
    }

    public static Constructor getDeclaredConstructor(Class c2, Class ... parameterTypes) throws ReflectionException {
        try {
            return new Constructor(c2.getDeclaredConstructor(parameterTypes));
        }
        catch (SecurityException e2) {
            throw new ReflectionException("Security violation while getting constructor for class: " + c2.getName(), e2);
        }
        catch (NoSuchMethodException e3) {
            throw new ReflectionException("Constructor not found for class: " + c2.getName(), e3);
        }
    }

    public static Object[] getEnumConstants(Class c2) {
        return c2.getEnumConstants();
    }

    public static Method[] getMethods(Class c2) {
        java.lang.reflect.Method[] methods = c2.getMethods();
        Method[] result = new Method[methods.length];
        int j2 = methods.length;
        for (int i2 = 0; i2 < j2; ++i2) {
            result[i2] = new Method(methods[i2]);
        }
        return result;
    }

    public static Method getMethod(Class c2, String name, Class ... parameterTypes) throws ReflectionException {
        try {
            return new Method(c2.getMethod(name, parameterTypes));
        }
        catch (SecurityException e2) {
            throw new ReflectionException("Security violation while getting method: " + name + ", for class: " + c2.getName(), e2);
        }
        catch (NoSuchMethodException e3) {
            throw new ReflectionException("Method not found: " + name + ", for class: " + c2.getName(), e3);
        }
    }

    public static Method[] getDeclaredMethods(Class c2) {
        java.lang.reflect.Method[] methods = c2.getDeclaredMethods();
        Method[] result = new Method[methods.length];
        int j2 = methods.length;
        for (int i2 = 0; i2 < j2; ++i2) {
            result[i2] = new Method(methods[i2]);
        }
        return result;
    }

    public static Method getDeclaredMethod(Class c2, String name, Class ... parameterTypes) throws ReflectionException {
        try {
            return new Method(c2.getDeclaredMethod(name, parameterTypes));
        }
        catch (SecurityException e2) {
            throw new ReflectionException("Security violation while getting method: " + name + ", for class: " + c2.getName(), e2);
        }
        catch (NoSuchMethodException e3) {
            throw new ReflectionException("Method not found: " + name + ", for class: " + c2.getName(), e3);
        }
    }

    public static Field[] getFields(Class c2) {
        java.lang.reflect.Field[] fields = c2.getFields();
        Field[] result = new Field[fields.length];
        int j2 = fields.length;
        for (int i2 = 0; i2 < j2; ++i2) {
            result[i2] = new Field(fields[i2]);
        }
        return result;
    }

    public static Field getField(Class c2, String name) throws ReflectionException {
        try {
            return new Field(c2.getField(name));
        }
        catch (SecurityException e2) {
            throw new ReflectionException("Security violation while getting field: " + name + ", for class: " + c2.getName(), e2);
        }
        catch (NoSuchFieldException e3) {
            throw new ReflectionException("Field not found: " + name + ", for class: " + c2.getName(), e3);
        }
    }

    public static Field[] getDeclaredFields(Class c2) {
        java.lang.reflect.Field[] fields = c2.getDeclaredFields();
        Field[] result = new Field[fields.length];
        int j2 = fields.length;
        for (int i2 = 0; i2 < j2; ++i2) {
            result[i2] = new Field(fields[i2]);
        }
        return result;
    }

    public static Field getDeclaredField(Class c2, String name) throws ReflectionException {
        try {
            return new Field(c2.getDeclaredField(name));
        }
        catch (SecurityException e2) {
            throw new ReflectionException("Security violation while getting field: " + name + ", for class: " + c2.getName(), e2);
        }
        catch (NoSuchFieldException e3) {
            throw new ReflectionException("Field not found: " + name + ", for class: " + c2.getName(), e3);
        }
    }

    public static boolean isAnnotationPresent(Class c2, Class<? extends java.lang.annotation.Annotation> annotationType) {
        return c2.isAnnotationPresent(annotationType);
    }

    public static Annotation[] getAnnotations(Class c2) {
        java.lang.annotation.Annotation[] annotations = c2.getAnnotations();
        Annotation[] result = new Annotation[annotations.length];
        for (int i2 = 0; i2 < annotations.length; ++i2) {
            result[i2] = new Annotation(annotations[i2]);
        }
        return result;
    }

    public static Annotation getAnnotation(Class c2, Class<? extends java.lang.annotation.Annotation> annotationType) {
        java.lang.annotation.Annotation annotation = c2.getAnnotation(annotationType);
        if (annotation != null) {
            return new Annotation(annotation);
        }
        return null;
    }

    public static Annotation[] getDeclaredAnnotations(Class c2) {
        java.lang.annotation.Annotation[] annotations = c2.getDeclaredAnnotations();
        Annotation[] result = new Annotation[annotations.length];
        for (int i2 = 0; i2 < annotations.length; ++i2) {
            result[i2] = new Annotation(annotations[i2]);
        }
        return result;
    }

    public static Annotation getDeclaredAnnotation(Class c2, Class<? extends java.lang.annotation.Annotation> annotationType) {
        java.lang.annotation.Annotation[] annotations;
        for (java.lang.annotation.Annotation annotation : annotations = c2.getDeclaredAnnotations()) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return new Annotation(annotation);
        }
        return null;
    }

    public static Class[] getInterfaces(Class c2) {
        return c2.getInterfaces();
    }
}

