/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import java.util.Arrays;
import java.util.Comparator;

class TimSort<T> {
    private static final int MIN_MERGE = 32;
    private T[] a;
    private Comparator<? super T> c;
    private static final int MIN_GALLOP = 7;
    private int minGallop = 7;
    private static final int INITIAL_TMP_STORAGE_LENGTH = 256;
    private T[] tmp;
    private int tmpCount;
    private int stackSize = 0;
    private final int[] runBase;
    private final int[] runLen;
    private static final boolean DEBUG = false;

    TimSort() {
        this.tmp = new Object[256];
        this.runBase = new int[40];
        this.runLen = new int[40];
    }

    public void doSort(T[] a2, Comparator<T> c2, int lo, int hi) {
        int runLen;
        this.stackSize = 0;
        TimSort.rangeCheck(a2.length, lo, hi);
        int nRemaining = hi - lo;
        if (nRemaining < 2) {
            return;
        }
        if (nRemaining < 32) {
            int initRunLen = TimSort.countRunAndMakeAscending(a2, lo, hi, c2);
            TimSort.binarySort(a2, lo, hi, lo + initRunLen, c2);
            return;
        }
        this.a = a2;
        this.c = c2;
        this.tmpCount = 0;
        int minRun = TimSort.minRunLength(nRemaining);
        do {
            if ((runLen = TimSort.countRunAndMakeAscending(a2, lo, hi, c2)) < minRun) {
                int force = nRemaining <= minRun ? nRemaining : minRun;
                TimSort.binarySort(a2, lo, lo + force, lo + runLen, c2);
                runLen = force;
            }
            this.pushRun(lo, runLen);
            this.mergeCollapse();
            lo += runLen;
        } while ((nRemaining -= runLen) != 0);
        this.mergeForceCollapse();
        this.a = null;
        this.c = null;
        T[] tmp = this.tmp;
        int n2 = this.tmpCount;
        for (int i2 = 0; i2 < n2; ++i2) {
            tmp[i2] = null;
        }
    }

    private TimSort(T[] a2, Comparator<? super T> c2) {
        this.a = a2;
        this.c = c2;
        int len = a2.length;
        Object[] newArray = new Object[len < 512 ? len >>> 1 : 256];
        this.tmp = newArray;
        int stackLen = len < 120 ? 5 : (len < 1542 ? 10 : (len < 119151 ? 19 : 40));
        this.runBase = new int[stackLen];
        this.runLen = new int[stackLen];
    }

    static <T> void sort(T[] a2, Comparator<? super T> c2) {
        TimSort.sort(a2, 0, a2.length, c2);
    }

    static <T> void sort(T[] a2, int lo, int hi, Comparator<? super T> c2) {
        int runLen;
        if (c2 == null) {
            Arrays.sort(a2, lo, hi);
            return;
        }
        TimSort.rangeCheck(a2.length, lo, hi);
        int nRemaining = hi - lo;
        if (nRemaining < 2) {
            return;
        }
        if (nRemaining < 32) {
            int initRunLen = TimSort.countRunAndMakeAscending(a2, lo, hi, c2);
            TimSort.binarySort(a2, lo, hi, lo + initRunLen, c2);
            return;
        }
        TimSort<? super T> ts = new TimSort<T>(a2, c2);
        int minRun = TimSort.minRunLength(nRemaining);
        do {
            if ((runLen = TimSort.countRunAndMakeAscending(a2, lo, hi, c2)) < minRun) {
                int force = nRemaining <= minRun ? nRemaining : minRun;
                TimSort.binarySort(a2, lo, lo + force, lo + runLen, c2);
                runLen = force;
            }
            super.pushRun(lo, runLen);
            super.mergeCollapse();
            lo += runLen;
        } while ((nRemaining -= runLen) != 0);
        super.mergeForceCollapse();
    }

    private static <T> void binarySort(T[] a2, int lo, int hi, int start, Comparator<? super T> c2) {
        if (start == lo) {
            ++start;
        }
        while (start < hi) {
            T pivot = a2[start];
            int left = lo;
            int right = start;
            while (left < right) {
                int mid = left + right >>> 1;
                if (c2.compare(pivot, a2[mid]) < 0) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            int n2 = start - left;
            switch (n2) {
                case 2: {
                    a2[left + 2] = a2[left + 1];
                }
                case 1: {
                    a2[left + 1] = a2[left];
                    break;
                }
                default: {
                    System.arraycopy(a2, left, a2, left + 1, n2);
                }
            }
            a2[left] = pivot;
            ++start;
        }
    }

    private static <T> int countRunAndMakeAscending(T[] a2, int lo, int hi, Comparator<? super T> c2) {
        int runHi = lo + 1;
        if (runHi == hi) {
            return 1;
        }
        if (c2.compare(a2[runHi++], a2[lo]) < 0) {
            while (runHi < hi && c2.compare(a2[runHi], a2[runHi - 1]) < 0) {
                ++runHi;
            }
            TimSort.reverseRange(a2, lo, runHi);
        } else {
            while (runHi < hi && c2.compare(a2[runHi], a2[runHi - 1]) >= 0) {
                ++runHi;
            }
        }
        return runHi - lo;
    }

    private static void reverseRange(Object[] a2, int lo, int hi) {
        --hi;
        while (lo < hi) {
            Object t2 = a2[lo];
            a2[lo++] = a2[hi];
            a2[hi--] = t2;
        }
    }

    private static int minRunLength(int n2) {
        int r2 = 0;
        while (n2 >= 32) {
            r2 |= n2 & 1;
            n2 >>= 1;
        }
        return n2 + r2;
    }

    private void pushRun(int runBase, int runLen) {
        this.runBase[this.stackSize] = runBase;
        this.runLen[this.stackSize] = runLen;
        ++this.stackSize;
    }

    private void mergeCollapse() {
        while (this.stackSize > 1) {
            int n2 = this.stackSize - 2;
            if (n2 >= 1 && this.runLen[n2 - 1] <= this.runLen[n2] + this.runLen[n2 + 1] || n2 >= 2 && this.runLen[n2 - 2] <= this.runLen[n2] + this.runLen[n2 - 1]) {
                if (this.runLen[n2 - 1] < this.runLen[n2 + 1]) {
                    --n2;
                }
            } else if (this.runLen[n2] > this.runLen[n2 + 1]) break;
            this.mergeAt(n2);
        }
    }

    private void mergeForceCollapse() {
        while (this.stackSize > 1) {
            int n2 = this.stackSize - 2;
            if (n2 > 0 && this.runLen[n2 - 1] < this.runLen[n2 + 1]) {
                --n2;
            }
            this.mergeAt(n2);
        }
    }

    private void mergeAt(int i2) {
        int base1 = this.runBase[i2];
        int len1 = this.runLen[i2];
        int base2 = this.runBase[i2 + 1];
        int len2 = this.runLen[i2 + 1];
        this.runLen[i2] = len1 + len2;
        if (i2 == this.stackSize - 3) {
            this.runBase[i2 + 1] = this.runBase[i2 + 2];
            this.runLen[i2 + 1] = this.runLen[i2 + 2];
        }
        --this.stackSize;
        int k2 = TimSort.gallopRight(this.a[base2], this.a, base1, len1, 0, this.c);
        base1 += k2;
        if ((len1 -= k2) == 0) {
            return;
        }
        if ((len2 = TimSort.gallopLeft(this.a[base1 + len1 - 1], this.a, base2, len2, len2 - 1, this.c)) == 0) {
            return;
        }
        if (len1 <= len2) {
            this.mergeLo(base1, len1, base2, len2);
        } else {
            this.mergeHi(base1, len1, base2, len2);
        }
    }

    private static <T> int gallopLeft(T key, T[] a2, int base, int len, int hint, Comparator<? super T> c2) {
        int maxOfs;
        int lastOfs = 0;
        int ofs = 1;
        if (c2.compare(key, a2[base + hint]) > 0) {
            maxOfs = len - hint;
            while (ofs < maxOfs && c2.compare(key, a2[base + hint + ofs]) > 0) {
                lastOfs = ofs;
                if ((ofs = (ofs << 1) + 1) > 0) continue;
                ofs = maxOfs;
            }
            if (ofs > maxOfs) {
                ofs = maxOfs;
            }
            lastOfs += hint;
            ofs += hint;
        } else {
            maxOfs = hint + 1;
            while (ofs < maxOfs && c2.compare(key, a2[base + hint - ofs]) <= 0) {
                lastOfs = ofs;
                if ((ofs = (ofs << 1) + 1) > 0) continue;
                ofs = maxOfs;
            }
            if (ofs > maxOfs) {
                ofs = maxOfs;
            }
            int tmp = lastOfs;
            lastOfs = hint - ofs;
            ofs = hint - tmp;
        }
        ++lastOfs;
        while (lastOfs < ofs) {
            int m2 = lastOfs + (ofs - lastOfs >>> 1);
            if (c2.compare(key, a2[base + m2]) > 0) {
                lastOfs = m2 + 1;
                continue;
            }
            ofs = m2;
        }
        return ofs;
    }

    private static <T> int gallopRight(T key, T[] a2, int base, int len, int hint, Comparator<? super T> c2) {
        int maxOfs;
        int ofs = 1;
        int lastOfs = 0;
        if (c2.compare(key, a2[base + hint]) < 0) {
            maxOfs = hint + 1;
            while (ofs < maxOfs && c2.compare(key, a2[base + hint - ofs]) < 0) {
                lastOfs = ofs;
                if ((ofs = (ofs << 1) + 1) > 0) continue;
                ofs = maxOfs;
            }
            if (ofs > maxOfs) {
                ofs = maxOfs;
            }
            int tmp = lastOfs;
            lastOfs = hint - ofs;
            ofs = hint - tmp;
        } else {
            maxOfs = len - hint;
            while (ofs < maxOfs && c2.compare(key, a2[base + hint + ofs]) >= 0) {
                lastOfs = ofs;
                if ((ofs = (ofs << 1) + 1) > 0) continue;
                ofs = maxOfs;
            }
            if (ofs > maxOfs) {
                ofs = maxOfs;
            }
            lastOfs += hint;
            ofs += hint;
        }
        ++lastOfs;
        while (lastOfs < ofs) {
            int m2 = lastOfs + (ofs - lastOfs >>> 1);
            if (c2.compare(key, a2[base + m2]) < 0) {
                ofs = m2;
                continue;
            }
            lastOfs = m2 + 1;
        }
        return ofs;
    }

    private void mergeLo(int base1, int len1, int base2, int len2) {
        T[] a2 = this.a;
        T[] tmp = this.ensureCapacity(len1);
        System.arraycopy(a2, base1, tmp, 0, len1);
        int cursor1 = 0;
        int cursor2 = base2;
        int dest = base1;
        a2[dest++] = a2[cursor2++];
        if (--len2 == 0) {
            System.arraycopy(tmp, cursor1, a2, dest, len1);
            return;
        }
        if (len1 == 1) {
            System.arraycopy(a2, cursor2, a2, dest, len2);
            a2[dest + len2] = tmp[cursor1];
            return;
        }
        Comparator<T> c2 = this.c;
        int minGallop = this.minGallop;
        block0: while (true) {
            int count1 = 0;
            int count2 = 0;
            do {
                if (c2.compare(a2[cursor2], tmp[cursor1]) < 0) {
                    a2[dest++] = a2[cursor2++];
                    ++count2;
                    count1 = 0;
                    if (--len2 != 0) continue;
                    break block0;
                }
                a2[dest++] = tmp[cursor1++];
                ++count1;
                count2 = 0;
                if (--len1 == 1) break block0;
            } while ((count1 | count2) < minGallop);
            do {
                if ((count1 = TimSort.gallopRight(a2[cursor2], tmp, cursor1, len1, 0, c2)) != 0) {
                    System.arraycopy(tmp, cursor1, a2, dest, count1);
                    dest += count1;
                    cursor1 += count1;
                    if ((len1 -= count1) <= 1) break block0;
                }
                a2[dest++] = a2[cursor2++];
                if (--len2 == 0) break block0;
                count2 = TimSort.gallopLeft(tmp[cursor1], a2, cursor2, len2, 0, c2);
                if (count2 != 0) {
                    System.arraycopy(a2, cursor2, a2, dest, count2);
                    dest += count2;
                    cursor2 += count2;
                    if ((len2 -= count2) == 0) break block0;
                }
                a2[dest++] = tmp[cursor1++];
                if (--len1 == 1) break block0;
                --minGallop;
            } while (count1 >= 7 | count2 >= 7);
            if (minGallop < 0) {
                minGallop = 0;
            }
            minGallop += 2;
        }
        int n2 = this.minGallop = minGallop < 1 ? 1 : minGallop;
        if (len1 == 1) {
            System.arraycopy(a2, cursor2, a2, dest, len2);
            a2[dest + len2] = tmp[cursor1];
        } else {
            if (len1 == 0) {
                throw new IllegalArgumentException("Comparison method violates its general contract!");
            }
            System.arraycopy(tmp, cursor1, a2, dest, len1);
        }
    }

    private void mergeHi(int base1, int len1, int base2, int len2) {
        T[] a2 = this.a;
        T[] tmp = this.ensureCapacity(len2);
        System.arraycopy(a2, base2, tmp, 0, len2);
        int cursor1 = base1 + len1 - 1;
        int cursor2 = len2 - 1;
        int dest = base2 + len2 - 1;
        a2[dest--] = a2[cursor1--];
        if (--len1 == 0) {
            System.arraycopy(tmp, 0, a2, dest - (len2 - 1), len2);
            return;
        }
        if (len2 == 1) {
            System.arraycopy(a2, (cursor1 -= len1) + 1, a2, (dest -= len1) + 1, len1);
            a2[dest] = tmp[cursor2];
            return;
        }
        Comparator<T> c2 = this.c;
        int minGallop = this.minGallop;
        block0: while (true) {
            int count1 = 0;
            int count2 = 0;
            do {
                if (c2.compare(tmp[cursor2], a2[cursor1]) < 0) {
                    a2[dest--] = a2[cursor1--];
                    ++count1;
                    count2 = 0;
                    if (--len1 != 0) continue;
                    break block0;
                }
                a2[dest--] = tmp[cursor2--];
                ++count2;
                count1 = 0;
                if (--len2 == 1) break block0;
            } while ((count1 | count2) < minGallop);
            do {
                if ((count1 = len1 - TimSort.gallopRight(tmp[cursor2], a2, base1, len1, len1 - 1, c2)) != 0) {
                    System.arraycopy(a2, (cursor1 -= count1) + 1, a2, (dest -= count1) + 1, count1);
                    if ((len1 -= count1) == 0) break block0;
                }
                a2[dest--] = tmp[cursor2--];
                if (--len2 == 1) break block0;
                count2 = len2 - TimSort.gallopLeft(a2[cursor1], tmp, 0, len2, len2 - 1, c2);
                if (count2 != 0) {
                    System.arraycopy(tmp, (cursor2 -= count2) + 1, a2, (dest -= count2) + 1, count2);
                    if ((len2 -= count2) <= 1) break block0;
                }
                a2[dest--] = a2[cursor1--];
                if (--len1 == 0) break block0;
                --minGallop;
            } while (count1 >= 7 | count2 >= 7);
            if (minGallop < 0) {
                minGallop = 0;
            }
            minGallop += 2;
        }
        int n2 = this.minGallop = minGallop < 1 ? 1 : minGallop;
        if (len2 == 1) {
            System.arraycopy(a2, (cursor1 -= len1) + 1, a2, (dest -= len1) + 1, len1);
            a2[dest] = tmp[cursor2];
        } else {
            if (len2 == 0) {
                throw new IllegalArgumentException("Comparison method violates its general contract!");
            }
            System.arraycopy(tmp, 0, a2, dest - (len2 - 1), len2);
        }
    }

    private T[] ensureCapacity(int minCapacity) {
        this.tmpCount = Math.max(this.tmpCount, minCapacity);
        if (this.tmp.length < minCapacity) {
            int newSize = minCapacity;
            newSize |= newSize >> 1;
            newSize |= newSize >> 2;
            newSize |= newSize >> 4;
            newSize |= newSize >> 8;
            newSize |= newSize >> 16;
            newSize = ++newSize < 0 ? minCapacity : Math.min(newSize, this.a.length >>> 1);
            Object[] newArray = new Object[newSize];
            this.tmp = newArray;
        }
        return this.tmp;
    }

    private static void rangeCheck(int arrayLen, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLen) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }
}

