/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Pool;

public class SortedIntList<E>
implements Iterable<Node<E>> {
    private NodePool<E> nodePool = new NodePool();
    private transient Iterator iterator;
    int size = 0;
    Node<E> first;

    @Null
    public E insert(int index, E value) {
        if (this.first != null) {
            Node<E> c2 = this.first;
            while (c2.n != null && c2.n.index <= index) {
                c2 = c2.n;
            }
            if (index > c2.index) {
                c2.n = this.nodePool.obtain(c2, c2.n, value, index);
                if (c2.n.n != null) {
                    c2.n.n.p = c2.n;
                }
                ++this.size;
            } else if (index < c2.index) {
                Node<E> newFirst = this.nodePool.obtain(null, this.first, value, index);
                this.first.p = newFirst;
                this.first = newFirst;
                ++this.size;
            } else {
                c2.value = value;
            }
        } else {
            this.first = this.nodePool.obtain(null, null, value, index);
            ++this.size;
        }
        return null;
    }

    public E get(int index) {
        E match = null;
        if (this.first != null) {
            Node<E> c2 = this.first;
            while (c2.n != null && c2.index < index) {
                c2 = c2.n;
            }
            if (c2.index == index) {
                match = c2.value;
            }
        }
        return match;
    }

    public void clear() {
        while (this.first != null) {
            this.nodePool.free(this.first);
            this.first = this.first.n;
        }
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public java.util.Iterator<Node<E>> iterator() {
        if (Collections.allocateIterators) {
            return new Iterator();
        }
        if (this.iterator == null) {
            this.iterator = new Iterator();
            return this.iterator;
        }
        return this.iterator.reset();
    }

    static class NodePool<E>
    extends Pool<Node<E>> {
        NodePool() {
        }

        @Override
        protected Node<E> newObject() {
            return new Node();
        }

        public Node<E> obtain(Node<E> p2, Node<E> n2, E value, int index) {
            Node newNode = (Node)super.obtain();
            newNode.p = p2;
            newNode.n = n2;
            newNode.value = value;
            newNode.index = index;
            return newNode;
        }
    }

    public static class Node<E> {
        protected Node<E> p;
        protected Node<E> n;
        public E value;
        public int index;
    }

    public class Iterator
    implements java.util.Iterator<Node<E>> {
        private Node<E> position;
        private Node<E> previousPosition;

        public Iterator() {
            this.reset();
        }

        @Override
        public boolean hasNext() {
            return this.position != null;
        }

        @Override
        public Node<E> next() {
            this.previousPosition = this.position;
            this.position = this.position.n;
            return this.previousPosition;
        }

        @Override
        public void remove() {
            if (this.previousPosition != null) {
                if (this.previousPosition == SortedIntList.this.first) {
                    SortedIntList.this.first = this.position;
                } else {
                    this.previousPosition.p.n = this.position;
                    if (this.position != null) {
                        this.position.p = this.previousPosition.p;
                    }
                }
                --SortedIntList.this.size;
            }
        }

        public Iterator reset() {
            this.position = SortedIntList.this.first;
            this.previousPosition = null;
            return this;
        }
    }
}

