/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.reflect.ArrayReflection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayMap<K, V>
implements Iterable<ObjectMap.Entry<K, V>> {
    public K[] keys;
    public V[] values;
    public int size;
    public boolean ordered;
    private transient Entries entries1;
    private transient Entries entries2;
    private transient Values values1;
    private transient Values values2;
    private transient Keys keys1;
    private transient Keys keys2;

    public ArrayMap() {
        this(true, 16);
    }

    public ArrayMap(int capacity) {
        this(true, capacity);
    }

    public ArrayMap(boolean ordered, int capacity) {
        this.ordered = ordered;
        this.keys = new Object[capacity];
        this.values = new Object[capacity];
    }

    public ArrayMap(boolean ordered, int capacity, Class keyArrayType, Class valueArrayType) {
        this.ordered = ordered;
        this.keys = (Object[])ArrayReflection.newInstance(keyArrayType, capacity);
        this.values = (Object[])ArrayReflection.newInstance(valueArrayType, capacity);
    }

    public ArrayMap(Class keyArrayType, Class valueArrayType) {
        this(false, 16, keyArrayType, valueArrayType);
    }

    public ArrayMap(ArrayMap array) {
        this(array.ordered, array.size, array.keys.getClass().getComponentType(), array.values.getClass().getComponentType());
        this.size = array.size;
        System.arraycopy(array.keys, 0, this.keys, 0, this.size);
        System.arraycopy(array.values, 0, this.values, 0, this.size);
    }

    public int put(K key, V value) {
        int index = this.indexOfKey(key);
        if (index == -1) {
            if (this.size == this.keys.length) {
                this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
            }
            index = this.size++;
        }
        this.keys[index] = key;
        this.values[index] = value;
        return index;
    }

    public int put(K key, V value, int index) {
        int existingIndex = this.indexOfKey(key);
        if (existingIndex != -1) {
            this.removeIndex(existingIndex);
        } else if (this.size == this.keys.length) {
            this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(this.keys, index, this.keys, index + 1, this.size - index);
        System.arraycopy(this.values, index, this.values, index + 1, this.size - index);
        this.keys[index] = key;
        this.values[index] = value;
        ++this.size;
        return index;
    }

    public void putAll(ArrayMap<? extends K, ? extends V> map) {
        this.putAll(map, 0, map.size);
    }

    public void putAll(ArrayMap<? extends K, ? extends V> map, int offset, int length) {
        if (offset + length > map.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + offset + " + " + length + " <= " + map.size);
        }
        int sizeNeeded = this.size + length - offset;
        if (sizeNeeded >= this.keys.length) {
            this.resize(Math.max(8, (int)((float)sizeNeeded * 1.75f)));
        }
        System.arraycopy(map.keys, offset, this.keys, this.size, length);
        System.arraycopy(map.values, offset, this.values, this.size, length);
        this.size += length;
    }

    @Null
    public V get(K key) {
        return this.get(key, null);
    }

    @Null
    public V get(K key, @Null V defaultValue) {
        int i2;
        K[] keys = this.keys;
        if (key == null) {
            for (i2 = this.size - 1; i2 >= 0; --i2) {
                if (keys[i2] != key) continue;
                return this.values[i2];
            }
        } else {
            while (i2 >= 0) {
                if (key.equals(keys[i2])) {
                    return this.values[i2];
                }
                --i2;
            }
        }
        return defaultValue;
    }

    @Null
    public K getKey(V value, boolean identity) {
        int i2;
        V[] values = this.values;
        if (identity || value == null) {
            for (i2 = this.size - 1; i2 >= 0; --i2) {
                if (values[i2] != value) continue;
                return this.keys[i2];
            }
        } else {
            while (i2 >= 0) {
                if (value.equals(values[i2])) {
                    return this.keys[i2];
                }
                --i2;
            }
        }
        return null;
    }

    public K getKeyAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.keys[index];
    }

    public V getValueAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.values[index];
    }

    public K firstKey() {
        if (this.size == 0) {
            throw new IllegalStateException("Map is empty.");
        }
        return this.keys[0];
    }

    public V firstValue() {
        if (this.size == 0) {
            throw new IllegalStateException("Map is empty.");
        }
        return this.values[0];
    }

    public void setKey(int index, K key) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        this.keys[index] = key;
    }

    public void setValue(int index, V value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        this.values[index] = value;
    }

    public void insert(int index, K key, V value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        if (this.size == this.keys.length) {
            this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(this.keys, index, this.keys, index + 1, this.size - index);
            System.arraycopy(this.values, index, this.values, index + 1, this.size - index);
        } else {
            this.keys[this.size] = this.keys[index];
            this.values[this.size] = this.values[index];
        }
        ++this.size;
        this.keys[index] = key;
        this.values[index] = value;
    }

    public boolean containsKey(K key) {
        K[] keys = this.keys;
        int i2 = this.size - 1;
        if (key == null) {
            while (i2 >= 0) {
                if (keys[i2--] != key) continue;
                return true;
            }
        } else {
            while (i2 >= 0) {
                if (!key.equals(keys[i2--])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsValue(V value, boolean identity) {
        V[] values = this.values;
        int i2 = this.size - 1;
        if (identity || value == null) {
            while (i2 >= 0) {
                if (values[i2--] != value) continue;
                return true;
            }
        } else {
            while (i2 >= 0) {
                if (!value.equals(values[i2--])) continue;
                return true;
            }
        }
        return false;
    }

    public int indexOfKey(K key) {
        K[] keys = this.keys;
        if (key == null) {
            int n2 = this.size;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (keys[i2] != key) continue;
                return i2;
            }
        } else {
            int n3 = this.size;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!key.equals(keys[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public int indexOfValue(V value, boolean identity) {
        V[] values = this.values;
        if (identity || value == null) {
            int n2 = this.size;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (values[i2] != value) continue;
                return i2;
            }
        } else {
            int n3 = this.size;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!value.equals(values[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    @Null
    public V removeKey(K key) {
        K[] keys = this.keys;
        if (key == null) {
            int n2 = this.size;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (keys[i2] != key) continue;
                V value = this.values[i2];
                this.removeIndex(i2);
                return value;
            }
        } else {
            int n3 = this.size;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!key.equals(keys[i3])) continue;
                V value = this.values[i3];
                this.removeIndex(i3);
                return value;
            }
        }
        return null;
    }

    public boolean removeValue(V value, boolean identity) {
        V[] values = this.values;
        if (identity || value == null) {
            int n2 = this.size;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (values[i2] != value) continue;
                this.removeIndex(i2);
                return true;
            }
        } else {
            int n3 = this.size;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!value.equals(values[i3])) continue;
                this.removeIndex(i3);
                return true;
            }
        }
        return false;
    }

    public void removeIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        K[] keys = this.keys;
        --this.size;
        if (this.ordered) {
            System.arraycopy(keys, index + 1, keys, index, this.size - index);
            System.arraycopy(this.values, index + 1, this.values, index, this.size - index);
        } else {
            keys[index] = keys[this.size];
            this.values[index] = this.values[this.size];
        }
        keys[this.size] = null;
        this.values[this.size] = null;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public K peekKey() {
        return this.keys[this.size - 1];
    }

    public V peekValue() {
        return this.values[this.size - 1];
    }

    public void clear(int maximumCapacity) {
        if (this.keys.length <= maximumCapacity) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(maximumCapacity);
    }

    public void clear() {
        Arrays.fill(this.keys, 0, this.size, null);
        Arrays.fill(this.values, 0, this.size, null);
        this.size = 0;
    }

    public void shrink() {
        if (this.keys.length == this.size) {
            return;
        }
        this.resize(this.size);
    }

    public void ensureCapacity(int additionalCapacity) {
        if (additionalCapacity < 0) {
            throw new IllegalArgumentException("additionalCapacity must be >= 0: " + additionalCapacity);
        }
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded > this.keys.length) {
            this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
    }

    protected void resize(int newSize) {
        Object[] newKeys = (Object[])ArrayReflection.newInstance(this.keys.getClass().getComponentType(), newSize);
        System.arraycopy(this.keys, 0, newKeys, 0, Math.min(this.size, newKeys.length));
        this.keys = newKeys;
        Object[] newValues = (Object[])ArrayReflection.newInstance(this.values.getClass().getComponentType(), newSize);
        System.arraycopy(this.values, 0, newValues, 0, Math.min(this.size, newValues.length));
        this.values = newValues;
    }

    public void reverse() {
        int lastIndex = this.size - 1;
        int n2 = this.size / 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            int ii = lastIndex - i2;
            K tempKey = this.keys[i2];
            this.keys[i2] = this.keys[ii];
            this.keys[ii] = tempKey;
            V tempValue = this.values[i2];
            this.values[i2] = this.values[ii];
            this.values[ii] = tempValue;
        }
    }

    public void shuffle() {
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            int ii = MathUtils.random(i2);
            K tempKey = this.keys[i2];
            this.keys[i2] = this.keys[ii];
            this.keys[ii] = tempKey;
            V tempValue = this.values[i2];
            this.values[i2] = this.values[ii];
            this.values[ii] = tempValue;
        }
    }

    public void truncate(int newSize) {
        if (this.size <= newSize) {
            return;
        }
        for (int i2 = newSize; i2 < this.size; ++i2) {
            this.keys[i2] = null;
            this.values[i2] = null;
        }
        this.size = newSize;
    }

    public int hashCode() {
        K[] keys = this.keys;
        V[] values = this.values;
        int h2 = 0;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            K key = keys[i2];
            V value = values[i2];
            if (key != null) {
                h2 += key.hashCode() * 31;
            }
            if (value == null) continue;
            h2 += value.hashCode();
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ArrayMap)) {
            return false;
        }
        ArrayMap other = (ArrayMap)obj;
        if (other.size != this.size) {
            return false;
        }
        K[] keys = this.keys;
        V[] values = this.values;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            K key = keys[i2];
            V value = values[i2];
            if (!(value == null ? other.get(key, ObjectMap.dummy) != null : !value.equals(other.get(key)))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ArrayMap)) {
            return false;
        }
        ArrayMap other = (ArrayMap)obj;
        if (other.size != this.size) {
            return false;
        }
        K[] keys = this.keys;
        V[] values = this.values;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (values[i2] == other.get(keys[i2], ObjectMap.dummy)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        K[] keys = this.keys;
        V[] values = this.values;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('{');
        buffer.append(keys[0]);
        buffer.append('=');
        buffer.append(values[0]);
        for (int i2 = 1; i2 < this.size; ++i2) {
            buffer.append(", ");
            buffer.append(keys[i2]);
            buffer.append('=');
            buffer.append(values[i2]);
        }
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public Iterator<ObjectMap.Entry<K, V>> iterator() {
        return this.entries();
    }

    public Entries<K, V> entries() {
        if (Collections.allocateIterators) {
            return new Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.index = 0;
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.index = 0;
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public Values<V> values() {
        if (Collections.allocateIterators) {
            return new Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.valid) {
            this.values1.index = 0;
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.index = 0;
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public Keys<K> keys() {
        if (Collections.allocateIterators) {
            return new Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.index = 0;
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.index = 0;
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }

    public static class Entries<K, V>
    implements Iterable<ObjectMap.Entry<K, V>>,
    Iterator<ObjectMap.Entry<K, V>> {
        private final ArrayMap<K, V> map;
        ObjectMap.Entry<K, V> entry = new ObjectMap.Entry();
        int index;
        boolean valid = true;

        public Entries(ArrayMap<K, V> map) {
            this.map = map;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.map.size;
        }

        @Override
        public Iterator<ObjectMap.Entry<K, V>> iterator() {
            return this;
        }

        @Override
        public ObjectMap.Entry<K, V> next() {
            if (this.index >= this.map.size) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            this.entry.key = this.map.keys[this.index];
            this.entry.value = this.map.values[this.index++];
            return this.entry;
        }

        @Override
        public void remove() {
            --this.index;
            this.map.removeIndex(this.index);
        }

        public void reset() {
            this.index = 0;
        }
    }

    public static class Values<V>
    implements Iterable<V>,
    Iterator<V> {
        private final ArrayMap<Object, V> map;
        int index;
        boolean valid = true;

        public Values(ArrayMap<Object, V> map) {
            this.map = map;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.map.size;
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }

        @Override
        public V next() {
            if (this.index >= this.map.size) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.map.values[this.index++];
        }

        @Override
        public void remove() {
            --this.index;
            this.map.removeIndex(this.index);
        }

        public void reset() {
            this.index = 0;
        }

        public Array<V> toArray() {
            return new Array(true, this.map.values, this.index, this.map.size - this.index);
        }

        public Array<V> toArray(Array array) {
            array.addAll(this.map.values, this.index, this.map.size - this.index);
            return array;
        }
    }

    public static class Keys<K>
    implements Iterable<K>,
    Iterator<K> {
        private final ArrayMap<K, Object> map;
        int index;
        boolean valid = true;

        public Keys(ArrayMap<K, Object> map) {
            this.map = map;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.map.size;
        }

        @Override
        public Iterator<K> iterator() {
            return this;
        }

        @Override
        public K next() {
            if (this.index >= this.map.size) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.map.keys[this.index++];
        }

        @Override
        public void remove() {
            --this.index;
            this.map.removeIndex(this.index);
        }

        public void reset() {
            this.index = 0;
        }

        public Array<K> toArray() {
            return new Array(true, this.map.keys, this.index, this.map.size - this.index);
        }

        public Array<K> toArray(Array array) {
            array.addAll(this.map.keys, this.index, this.map.size - this.index);
            return array;
        }
    }
}

