/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.utils;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Align;

public class TiledDrawable
extends TextureRegionDrawable {
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private float scale = 1.0f;
    private int align = 12;

    public TiledDrawable() {
    }

    public TiledDrawable(TextureRegion region) {
        super(region);
    }

    public TiledDrawable(TextureRegionDrawable drawable) {
        super(drawable);
    }

    @Override
    public void draw(Batch batch, float x2, float y2, float width, float height) {
        float oldColor = batch.getPackedColor();
        batch.setColor(batch.getColor().mul(this.color));
        TiledDrawable.draw(batch, this.getRegion(), x2, y2, width, height, this.scale, this.align);
        batch.setPackedColor(oldColor);
    }

    public static void draw(Batch batch, TextureRegion textureRegion, float x2, float y2, float width, float height, float scale, int align) {
        float bottomPartialHeight;
        float topPartialHeight;
        float rightPartialWidth;
        float leftPartialWidth;
        float regionWidth = (float)textureRegion.getRegionWidth() * scale;
        float regionHeight = (float)textureRegion.getRegionHeight() * scale;
        Texture texture = textureRegion.getTexture();
        float textureWidth = (float)texture.getWidth() * scale;
        float textureHeight = (float)texture.getHeight() * scale;
        float u2 = textureRegion.getU();
        float v2 = textureRegion.getV();
        float u22 = textureRegion.getU2();
        float v22 = textureRegion.getV2();
        int fullX = (int)(width / regionWidth);
        if (Align.isLeft(align)) {
            leftPartialWidth = 0.0f;
            rightPartialWidth = width - regionWidth * (float)fullX;
        } else if (Align.isRight(align)) {
            leftPartialWidth = width - regionWidth * (float)fullX;
            rightPartialWidth = 0.0f;
        } else if (fullX != 0) {
            float leftRight;
            fullX = fullX % 2 == 1 ? fullX : fullX - 1;
            leftPartialWidth = leftRight = 0.5f * (width - regionWidth * (float)fullX);
            rightPartialWidth = leftRight;
        } else {
            leftPartialWidth = 0.0f;
            rightPartialWidth = 0.0f;
        }
        int fullY = (int)(height / regionHeight);
        if (Align.isTop(align)) {
            topPartialHeight = 0.0f;
            bottomPartialHeight = height - regionHeight * (float)fullY;
        } else if (Align.isBottom(align)) {
            topPartialHeight = height - regionHeight * (float)fullY;
            bottomPartialHeight = 0.0f;
        } else if (fullY != 0) {
            float topBottom;
            fullY = fullY % 2 == 1 ? fullY : fullY - 1;
            topPartialHeight = topBottom = 0.5f * (height - regionHeight * (float)fullY);
            bottomPartialHeight = topBottom;
        } else {
            topPartialHeight = 0.0f;
            bottomPartialHeight = 0.0f;
        }
        float drawX = x2;
        float drawY = y2;
        if (leftPartialWidth > 0.0f) {
            float leftEdgeU = u22 - leftPartialWidth / textureWidth;
            if (bottomPartialHeight > 0.0f) {
                float leftBottomV = v2 + bottomPartialHeight / textureHeight;
                batch.draw(texture, drawX, drawY, leftPartialWidth, bottomPartialHeight, leftEdgeU, leftBottomV, u22, v2);
                drawY += bottomPartialHeight;
            }
            if (fullY == 0 && Align.isCenterVertical(align)) {
                float vOffset = 0.5f * (v22 - v2) * (1.0f - height / regionHeight);
                float leftCenterV = v22 - vOffset;
                float leftCenterV2 = v2 + vOffset;
                batch.draw(texture, drawX, drawY, leftPartialWidth, height, leftEdgeU, leftCenterV, u22, leftCenterV2);
                drawY += height;
            } else {
                for (int i2 = 0; i2 < fullY; ++i2) {
                    batch.draw(texture, drawX, drawY, leftPartialWidth, regionHeight, leftEdgeU, v22, u22, v2);
                    drawY += regionHeight;
                }
            }
            if (topPartialHeight > 0.0f) {
                float leftTopV = v22 - topPartialHeight / textureHeight;
                batch.draw(texture, drawX, drawY, leftPartialWidth, topPartialHeight, leftEdgeU, v22, u22, leftTopV);
            }
        }
        if (bottomPartialHeight > 0.0f) {
            drawX = x2 + leftPartialWidth;
            drawY = y2;
            float centerBottomV = v2 + bottomPartialHeight / textureHeight;
            if (fullX == 0 && Align.isCenterHorizontal(align)) {
                float uOffset = 0.5f * (u22 - u2) * (1.0f - width / regionWidth);
                float centerBottomU = u2 + uOffset;
                float centerBottomU2 = u22 - uOffset;
                batch.draw(texture, drawX, drawY, width, bottomPartialHeight, centerBottomU, centerBottomV, centerBottomU2, v2);
                drawX += width;
            } else {
                for (int i3 = 0; i3 < fullX; ++i3) {
                    batch.draw(texture, drawX, drawY, regionWidth, bottomPartialHeight, u2, centerBottomV, u22, v2);
                    drawX += regionWidth;
                }
            }
        }
        drawX = x2 + leftPartialWidth;
        int originalFullX = fullX;
        int originalFullY = fullY;
        float centerCenterDrawWidth = regionWidth;
        float centerCenterDrawHeight = regionHeight;
        float centerCenterU = u2;
        float centerCenterU2 = u22;
        float centerCenterV = v22;
        float centerCenterV2 = v2;
        if (fullX == 0 && Align.isCenterHorizontal(align)) {
            fullX = 1;
            centerCenterDrawWidth = width;
            float uOffset = 0.5f * (u22 - u2) * (1.0f - width / regionWidth);
            centerCenterU = u2 + uOffset;
            centerCenterU2 = u22 - uOffset;
        }
        if (fullY == 0 && Align.isCenterVertical(align)) {
            fullY = 1;
            centerCenterDrawHeight = height;
            float vOffset = 0.5f * (v22 - v2) * (1.0f - height / regionHeight);
            centerCenterV = v22 - vOffset;
            centerCenterV2 = v2 + vOffset;
        }
        for (int i4 = 0; i4 < fullX; ++i4) {
            drawY = y2 + bottomPartialHeight;
            for (int ii = 0; ii < fullY; ++ii) {
                batch.draw(texture, drawX, drawY, centerCenterDrawWidth, centerCenterDrawHeight, centerCenterU, centerCenterV, centerCenterU2, centerCenterV2);
                drawY += centerCenterDrawHeight;
            }
            drawX += centerCenterDrawWidth;
        }
        fullX = originalFullX;
        fullY = originalFullY;
        if (topPartialHeight > 0.0f) {
            drawX = x2 + leftPartialWidth;
            float centerTopV = v22 - topPartialHeight / textureHeight;
            if (fullX == 0 && Align.isCenterHorizontal(align)) {
                float uOffset = 0.5f * (u22 - u2) * (1.0f - width / regionWidth);
                float centerTopU = u2 + uOffset;
                float centerTopU2 = u22 - uOffset;
                batch.draw(texture, drawX, drawY, width, topPartialHeight, centerTopU, v22, centerTopU2, centerTopV);
                drawX += width;
            } else {
                for (int i5 = 0; i5 < fullX; ++i5) {
                    batch.draw(texture, drawX, drawY, regionWidth, topPartialHeight, u2, v22, u22, centerTopV);
                    drawX += regionWidth;
                }
            }
        }
        if (rightPartialWidth > 0.0f) {
            drawY = y2;
            float rightEdgeU2 = u2 + rightPartialWidth / textureWidth;
            if (bottomPartialHeight > 0.0f) {
                float rightBottomV = v2 + bottomPartialHeight / textureHeight;
                batch.draw(texture, drawX, drawY, rightPartialWidth, bottomPartialHeight, u2, rightBottomV, rightEdgeU2, v2);
                drawY += bottomPartialHeight;
            }
            if (fullY == 0 && Align.isCenterVertical(align)) {
                float vOffset = 0.5f * (v22 - v2) * (1.0f - height / regionHeight);
                float rightCenterV = v22 - vOffset;
                float rightCenterV2 = v2 + vOffset;
                batch.draw(texture, drawX, drawY, rightPartialWidth, height, u2, rightCenterV, rightEdgeU2, rightCenterV2);
                drawY += height;
            } else {
                for (int i6 = 0; i6 < fullY; ++i6) {
                    batch.draw(texture, drawX, drawY, rightPartialWidth, regionHeight, u2, v22, rightEdgeU2, v2);
                    drawY += regionHeight;
                }
            }
            if (topPartialHeight > 0.0f) {
                float rightTopV = v22 - topPartialHeight / textureHeight;
                batch.draw(texture, drawX, drawY, rightPartialWidth, topPartialHeight, u2, v22, rightEdgeU2, rightTopV);
            }
        }
    }

    @Override
    public void draw(Batch batch, float x2, float y2, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        throw new UnsupportedOperationException();
    }

    public Color getColor() {
        return this.color;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int align) {
        this.align = align;
    }

    @Override
    public TiledDrawable tint(Color tint) {
        TiledDrawable drawable = new TiledDrawable(this);
        drawable.color.set(tint);
        drawable.setLeftWidth(this.getLeftWidth());
        drawable.setRightWidth(this.getRightWidth());
        drawable.setTopHeight(this.getTopHeight());
        drawable.setBottomHeight(this.getBottomHeight());
        return drawable;
    }
}

