/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.utils;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.utils.DragListener;
import com.badlogic.gdx.utils.Timer;

public class DragScrollListener
extends DragListener {
    static final Vector2 tmpCoords = new Vector2();
    private ScrollPane scroll;
    private Timer.Task scrollUp;
    private Timer.Task scrollDown;
    Interpolation interpolation = Interpolation.exp5In;
    float minSpeed = 15.0f;
    float maxSpeed = 75.0f;
    float tickSecs = 0.05f;
    long startTime;
    long rampTime = 1750L;
    float padTop;
    float padBottom;

    public DragScrollListener(final ScrollPane scroll) {
        this.scroll = scroll;
        this.scrollUp = new Timer.Task(){

            @Override
            public void run() {
                DragScrollListener.this.scroll(scroll.getScrollY() - DragScrollListener.this.getScrollPixels());
            }
        };
        this.scrollDown = new Timer.Task(){

            @Override
            public void run() {
                DragScrollListener.this.scroll(scroll.getScrollY() + DragScrollListener.this.getScrollPixels());
            }
        };
    }

    public void setup(float minSpeedPixels, float maxSpeedPixels, float tickSecs, float rampSecs) {
        this.minSpeed = minSpeedPixels;
        this.maxSpeed = maxSpeedPixels;
        this.tickSecs = tickSecs;
        this.rampTime = (long)(rampSecs * 1000.0f);
    }

    float getScrollPixels() {
        return this.interpolation.apply(this.minSpeed, this.maxSpeed, Math.min(1.0f, (float)(System.currentTimeMillis() - this.startTime) / (float)this.rampTime));
    }

    @Override
    public void drag(InputEvent event, float x2, float y2, int pointer) {
        event.getListenerActor().localToActorCoordinates(this.scroll, tmpCoords.set(x2, y2));
        if (this.isAbove(DragScrollListener.tmpCoords.y)) {
            this.scrollDown.cancel();
            if (!this.scrollUp.isScheduled()) {
                this.startTime = System.currentTimeMillis();
                Timer.schedule(this.scrollUp, this.tickSecs, this.tickSecs);
            }
            return;
        }
        if (this.isBelow(DragScrollListener.tmpCoords.y)) {
            this.scrollUp.cancel();
            if (!this.scrollDown.isScheduled()) {
                this.startTime = System.currentTimeMillis();
                Timer.schedule(this.scrollDown, this.tickSecs, this.tickSecs);
            }
            return;
        }
        this.scrollUp.cancel();
        this.scrollDown.cancel();
    }

    @Override
    public void dragStop(InputEvent event, float x2, float y2, int pointer) {
        this.scrollUp.cancel();
        this.scrollDown.cancel();
    }

    protected boolean isAbove(float y2) {
        return y2 >= this.scroll.getHeight() - this.padTop;
    }

    protected boolean isBelow(float y2) {
        return y2 < this.padBottom;
    }

    protected void scroll(float y2) {
        this.scroll.setScrollY(y2);
    }

    public void setPadding(float padTop, float padBottom) {
        this.padTop = padTop;
        this.padBottom = padBottom;
    }
}

