/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Value;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.SnapshotArray;
import java.util.Arrays;

public class Table
extends WidgetGroup {
    public static Color debugTableColor = new Color(0.0f, 0.0f, 1.0f, 1.0f);
    public static Color debugCellColor = new Color(1.0f, 0.0f, 0.0f, 1.0f);
    public static Color debugActorColor = new Color(0.0f, 1.0f, 0.0f, 1.0f);
    static final Pool<Cell> cellPool = new Pool<Cell>(){

        @Override
        protected Cell newObject() {
            return new Cell();
        }
    };
    private static float[] columnWeightedWidth;
    private static float[] rowWeightedHeight;
    private int columns;
    private int rows;
    private boolean implicitEndRow;
    private final Array<Cell> cells = new Array(4);
    private final Cell cellDefaults;
    private final Array<Cell> columnDefaults = new Array(2);
    private Cell rowDefaults;
    private boolean sizeInvalid = true;
    private float[] columnMinWidth;
    private float[] rowMinHeight;
    private float[] columnPrefWidth;
    private float[] rowPrefHeight;
    private float tableMinWidth;
    private float tableMinHeight;
    private float tablePrefWidth;
    private float tablePrefHeight;
    private float[] columnWidth;
    private float[] rowHeight;
    private float[] expandWidth;
    private float[] expandHeight;
    Value padTop = backgroundTop;
    Value padLeft = backgroundLeft;
    Value padBottom = backgroundBottom;
    Value padRight = backgroundRight;
    int align = 1;
    Debug debug = Debug.none;
    Array<DebugRect> debugRects;
    @Null
    Drawable background;
    private boolean clip;
    @Null
    private Skin skin;
    boolean round = true;
    public static Value backgroundTop;
    public static Value backgroundLeft;
    public static Value backgroundBottom;
    public static Value backgroundRight;

    public Table() {
        this((Skin)null);
    }

    public Table(@Null Skin skin) {
        this.skin = skin;
        this.cellDefaults = this.obtainCell();
        this.setTransform(false);
        this.setTouchable(Touchable.childrenOnly);
    }

    private Cell obtainCell() {
        Cell cell = cellPool.obtain();
        cell.setTable(this);
        return cell;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.validate();
        if (this.isTransform()) {
            this.applyTransform(batch, this.computeTransform());
            this.drawBackground(batch, parentAlpha, 0.0f, 0.0f);
            if (this.clip) {
                batch.flush();
                float padLeft = this.padLeft.get(this);
                float padBottom = this.padBottom.get(this);
                if (this.clipBegin(padLeft, padBottom, this.getWidth() - padLeft - this.padRight.get(this), this.getHeight() - padBottom - this.padTop.get(this))) {
                    this.drawChildren(batch, parentAlpha);
                    batch.flush();
                    this.clipEnd();
                }
            } else {
                this.drawChildren(batch, parentAlpha);
            }
            this.resetTransform(batch);
        } else {
            this.drawBackground(batch, parentAlpha, this.getX(), this.getY());
            super.draw(batch, parentAlpha);
        }
    }

    protected void drawBackground(Batch batch, float parentAlpha, float x2, float y2) {
        if (this.background == null) {
            return;
        }
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        this.background.draw(batch, x2, y2, this.getWidth(), this.getHeight());
    }

    public void setBackground(String drawableName) {
        if (this.skin == null) {
            throw new IllegalStateException("Table must have a skin set to use this method.");
        }
        this.setBackground(this.skin.getDrawable(drawableName));
    }

    public void setBackground(@Null Drawable background) {
        if (this.background == background) {
            return;
        }
        float padTopOld = this.getPadTop();
        float padLeftOld = this.getPadLeft();
        float padBottomOld = this.getPadBottom();
        float padRightOld = this.getPadRight();
        this.background = background;
        float padTopNew = this.getPadTop();
        float padLeftNew = this.getPadLeft();
        float padBottomNew = this.getPadBottom();
        float padRightNew = this.getPadRight();
        if (padTopOld + padBottomOld != padTopNew + padBottomNew || padLeftOld + padRightOld != padLeftNew + padRightNew) {
            this.invalidateHierarchy();
        } else if (padTopOld != padTopNew || padLeftOld != padLeftNew || padBottomOld != padBottomNew || padRightOld != padRightNew) {
            this.invalidate();
        }
    }

    public Table background(@Null Drawable background) {
        this.setBackground(background);
        return this;
    }

    public Table background(String drawableName) {
        this.setBackground(drawableName);
        return this;
    }

    @Null
    public Drawable getBackground() {
        return this.background;
    }

    @Override
    @Null
    public Actor hit(float x2, float y2, boolean touchable) {
        if (this.clip) {
            if (touchable && this.getTouchable() == Touchable.disabled) {
                return null;
            }
            if (x2 < 0.0f || x2 >= this.getWidth() || y2 < 0.0f || y2 >= this.getHeight()) {
                return null;
            }
        }
        return super.hit(x2, y2, touchable);
    }

    public Table clip() {
        this.setClip(true);
        return this;
    }

    public Table clip(boolean enabled) {
        this.setClip(enabled);
        return this;
    }

    public void setClip(boolean enabled) {
        this.clip = enabled;
        this.setTransform(enabled);
        this.invalidate();
    }

    public boolean getClip() {
        return this.clip;
    }

    @Override
    public void invalidate() {
        this.sizeInvalid = true;
        super.invalidate();
    }

    public <T extends Actor> Cell<T> add(@Null T actor) {
        Cell cell;
        block10: {
            int cellCount;
            cell = this.obtainCell();
            cell.actor = actor;
            if (this.implicitEndRow) {
                this.implicitEndRow = false;
                --this.rows;
                this.cells.peek().endRow = false;
            }
            if ((cellCount = this.cells.size) > 0) {
                Cell lastCell = this.cells.peek();
                if (!lastCell.endRow) {
                    cell.column = lastCell.column + lastCell.colspan;
                    cell.row = lastCell.row;
                } else {
                    cell.column = 0;
                    cell.row = lastCell.row + 1;
                }
                if (cell.row > 0) {
                    T[] cells = this.cells.items;
                    for (int i2 = cellCount - 1; i2 >= 0; --i2) {
                        int column;
                        Cell other = (Cell)cells[i2];
                        int nn = column + other.colspan;
                        for (column = other.column; column < nn; ++column) {
                            if (column != cell.column) continue;
                            cell.cellAboveIndex = i2;
                            break block10;
                        }
                    }
                }
            } else {
                cell.column = 0;
                cell.row = 0;
            }
        }
        this.cells.add(cell);
        cell.set(this.cellDefaults);
        if (cell.column < this.columnDefaults.size) {
            cell.merge(this.columnDefaults.get(cell.column));
        }
        cell.merge(this.rowDefaults);
        if (actor != null) {
            this.addActor(actor);
        }
        return cell;
    }

    public Table add(Actor ... actors) {
        int n2 = actors.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.add((T)actors[i2]);
        }
        return this;
    }

    public Cell<Label> add(@Null CharSequence text) {
        if (this.skin == null) {
            throw new IllegalStateException("Table must have a skin set to use this method.");
        }
        return this.add((T)new Label(text, this.skin));
    }

    public Cell<Label> add(@Null CharSequence text, String labelStyleName) {
        if (this.skin == null) {
            throw new IllegalStateException("Table must have a skin set to use this method.");
        }
        return this.add((T)new Label(text, this.skin.get(labelStyleName, Label.LabelStyle.class)));
    }

    public Cell<Label> add(@Null CharSequence text, String fontName, @Null Color color) {
        if (this.skin == null) {
            throw new IllegalStateException("Table must have a skin set to use this method.");
        }
        return this.add((T)new Label(text, new Label.LabelStyle(this.skin.getFont(fontName), color)));
    }

    public Cell<Label> add(@Null CharSequence text, String fontName, String colorName) {
        if (this.skin == null) {
            throw new IllegalStateException("Table must have a skin set to use this method.");
        }
        return this.add((T)new Label(text, new Label.LabelStyle(this.skin.getFont(fontName), this.skin.getColor(colorName))));
    }

    public Cell add() {
        return this.add((T)null);
    }

    public Cell<Stack> stack(Actor ... actors) {
        Stack stack = new Stack();
        if (actors != null) {
            int n2 = actors.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                stack.addActor(actors[i2]);
            }
        }
        return this.add((T)stack);
    }

    @Override
    public boolean removeActor(Actor actor) {
        return this.removeActor(actor, true);
    }

    @Override
    public boolean removeActor(Actor actor, boolean unfocus) {
        if (!super.removeActor(actor, unfocus)) {
            return false;
        }
        Cell<Actor> cell = this.getCell(actor);
        if (cell != null) {
            cell.actor = null;
        }
        return true;
    }

    @Override
    public Actor removeActorAt(int index, boolean unfocus) {
        Actor actor = super.removeActorAt(index, unfocus);
        Cell<Actor> cell = this.getCell(actor);
        if (cell != null) {
            cell.actor = null;
        }
        return actor;
    }

    @Override
    public void clearChildren(boolean unfocus) {
        T[] cells = this.cells.items;
        for (int i2 = this.cells.size - 1; i2 >= 0; --i2) {
            Cell cell = (Cell)cells[i2];
            Actor actor = cell.actor;
            if (actor == null) continue;
            actor.remove();
        }
        cellPool.freeAll(this.cells);
        this.cells.clear();
        this.rows = 0;
        this.columns = 0;
        if (this.rowDefaults != null) {
            cellPool.free(this.rowDefaults);
        }
        this.rowDefaults = null;
        this.implicitEndRow = false;
        super.clearChildren(unfocus);
    }

    public void reset() {
        this.clearChildren();
        this.padTop = backgroundTop;
        this.padLeft = backgroundLeft;
        this.padBottom = backgroundBottom;
        this.padRight = backgroundRight;
        this.align = 1;
        this.debug(Debug.none);
        this.cellDefaults.reset();
        int n2 = this.columnDefaults.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Cell columnCell = this.columnDefaults.get(i2);
            if (columnCell == null) continue;
            cellPool.free(columnCell);
        }
        this.columnDefaults.clear();
    }

    public Cell row() {
        if (this.cells.size > 0) {
            if (!this.implicitEndRow) {
                if (this.cells.peek().endRow) {
                    return this.rowDefaults;
                }
                this.endRow();
            }
            this.invalidate();
        }
        this.implicitEndRow = false;
        if (this.rowDefaults != null) {
            cellPool.free(this.rowDefaults);
        }
        this.rowDefaults = this.obtainCell();
        this.rowDefaults.clear();
        return this.rowDefaults;
    }

    private void endRow() {
        T[] cells = this.cells.items;
        int rowColumns = 0;
        for (int i2 = this.cells.size - 1; i2 >= 0; --i2) {
            Cell cell = (Cell)cells[i2];
            if (cell.endRow) break;
            rowColumns += cell.colspan.intValue();
        }
        this.columns = Math.max(this.columns, rowColumns);
        ++this.rows;
        this.cells.peek().endRow = true;
    }

    public Cell columnDefaults(int column) {
        Cell cell;
        Cell cell2 = cell = this.columnDefaults.size > column ? this.columnDefaults.get(column) : null;
        if (cell == null) {
            cell = this.obtainCell();
            cell.clear();
            if (column >= this.columnDefaults.size) {
                for (int i2 = this.columnDefaults.size; i2 < column; ++i2) {
                    this.columnDefaults.add(null);
                }
                this.columnDefaults.add(cell);
            } else {
                this.columnDefaults.set(column, cell);
            }
        }
        return cell;
    }

    @Null
    public <T extends Actor> Cell<T> getCell(T actor) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        T[] cells = this.cells.items;
        int n2 = this.cells.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Cell c2 = (Cell)cells[i2];
            if (c2.actor != actor) continue;
            return c2;
        }
        return null;
    }

    public Array<Cell> getCells() {
        return this.cells;
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float width = this.tablePrefWidth;
        if (this.background != null) {
            return Math.max(width, this.background.getMinWidth());
        }
        return width;
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float height = this.tablePrefHeight;
        if (this.background != null) {
            return Math.max(height, this.background.getMinHeight());
        }
        return height;
    }

    @Override
    public float getMinWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.tableMinWidth;
    }

    @Override
    public float getMinHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.tableMinHeight;
    }

    public Cell defaults() {
        return this.cellDefaults;
    }

    public Table pad(Value pad) {
        if (pad == null) {
            throw new IllegalArgumentException("pad cannot be null.");
        }
        this.padTop = pad;
        this.padLeft = pad;
        this.padBottom = pad;
        this.padRight = pad;
        this.sizeInvalid = true;
        return this;
    }

    public Table pad(Value top, Value left, Value bottom, Value right) {
        if (top == null) {
            throw new IllegalArgumentException("top cannot be null.");
        }
        if (left == null) {
            throw new IllegalArgumentException("left cannot be null.");
        }
        if (bottom == null) {
            throw new IllegalArgumentException("bottom cannot be null.");
        }
        if (right == null) {
            throw new IllegalArgumentException("right cannot be null.");
        }
        this.padTop = top;
        this.padLeft = left;
        this.padBottom = bottom;
        this.padRight = right;
        this.sizeInvalid = true;
        return this;
    }

    public Table padTop(Value padTop) {
        if (padTop == null) {
            throw new IllegalArgumentException("padTop cannot be null.");
        }
        this.padTop = padTop;
        this.sizeInvalid = true;
        return this;
    }

    public Table padLeft(Value padLeft) {
        if (padLeft == null) {
            throw new IllegalArgumentException("padLeft cannot be null.");
        }
        this.padLeft = padLeft;
        this.sizeInvalid = true;
        return this;
    }

    public Table padBottom(Value padBottom) {
        if (padBottom == null) {
            throw new IllegalArgumentException("padBottom cannot be null.");
        }
        this.padBottom = padBottom;
        this.sizeInvalid = true;
        return this;
    }

    public Table padRight(Value padRight) {
        if (padRight == null) {
            throw new IllegalArgumentException("padRight cannot be null.");
        }
        this.padRight = padRight;
        this.sizeInvalid = true;
        return this;
    }

    public Table pad(float pad) {
        this.pad(Value.Fixed.valueOf(pad));
        return this;
    }

    public Table pad(float top, float left, float bottom, float right) {
        this.padTop = Value.Fixed.valueOf(top);
        this.padLeft = Value.Fixed.valueOf(left);
        this.padBottom = Value.Fixed.valueOf(bottom);
        this.padRight = Value.Fixed.valueOf(right);
        this.sizeInvalid = true;
        return this;
    }

    public Table padTop(float padTop) {
        this.padTop = Value.Fixed.valueOf(padTop);
        this.sizeInvalid = true;
        return this;
    }

    public Table padLeft(float padLeft) {
        this.padLeft = Value.Fixed.valueOf(padLeft);
        this.sizeInvalid = true;
        return this;
    }

    public Table padBottom(float padBottom) {
        this.padBottom = Value.Fixed.valueOf(padBottom);
        this.sizeInvalid = true;
        return this;
    }

    public Table padRight(float padRight) {
        this.padRight = Value.Fixed.valueOf(padRight);
        this.sizeInvalid = true;
        return this;
    }

    public Table align(int align) {
        this.align = align;
        return this;
    }

    public Table center() {
        this.align = 1;
        return this;
    }

    public Table top() {
        this.align |= 2;
        this.align &= 0xFFFFFFFB;
        return this;
    }

    public Table left() {
        this.align |= 8;
        this.align &= 0xFFFFFFEF;
        return this;
    }

    public Table bottom() {
        this.align |= 4;
        this.align &= 0xFFFFFFFD;
        return this;
    }

    public Table right() {
        this.align |= 0x10;
        this.align &= 0xFFFFFFF7;
        return this;
    }

    @Override
    public void setDebug(boolean enabled) {
        this.debug(enabled ? Debug.all : Debug.none);
    }

    @Override
    public Table debug() {
        super.debug();
        return this;
    }

    @Override
    public Table debugAll() {
        super.debugAll();
        return this;
    }

    public Table debugTable() {
        super.setDebug(true);
        if (this.debug != Debug.table) {
            this.debug = Debug.table;
            this.invalidate();
        }
        return this;
    }

    public Table debugCell() {
        super.setDebug(true);
        if (this.debug != Debug.cell) {
            this.debug = Debug.cell;
            this.invalidate();
        }
        return this;
    }

    public Table debugActor() {
        super.setDebug(true);
        if (this.debug != Debug.actor) {
            this.debug = Debug.actor;
            this.invalidate();
        }
        return this;
    }

    public Table debug(Debug debug) {
        super.setDebug(debug != Debug.none);
        if (this.debug != debug) {
            this.debug = debug;
            if (debug == Debug.none) {
                this.clearDebugRects();
            } else {
                this.invalidate();
            }
        }
        return this;
    }

    public Debug getTableDebug() {
        return this.debug;
    }

    public Value getPadTopValue() {
        return this.padTop;
    }

    public float getPadTop() {
        return this.padTop.get(this);
    }

    public Value getPadLeftValue() {
        return this.padLeft;
    }

    public float getPadLeft() {
        return this.padLeft.get(this);
    }

    public Value getPadBottomValue() {
        return this.padBottom;
    }

    public float getPadBottom() {
        return this.padBottom.get(this);
    }

    public Value getPadRightValue() {
        return this.padRight;
    }

    public float getPadRight() {
        return this.padRight.get(this);
    }

    public float getPadX() {
        return this.padLeft.get(this) + this.padRight.get(this);
    }

    public float getPadY() {
        return this.padTop.get(this) + this.padBottom.get(this);
    }

    public int getAlign() {
        return this.align;
    }

    public int getRow(float y2) {
        int n2 = this.cells.size;
        if (n2 == 0) {
            return -1;
        }
        y2 += this.getPadTop();
        T[] cells = this.cells.items;
        int i2 = 0;
        int row = 0;
        while (i2 < n2) {
            Cell c2 = (Cell)cells[i2++];
            if (c2.actorY + c2.computedPadTop < y2) {
                return row;
            }
            if (!c2.endRow) continue;
            ++row;
        }
        return -1;
    }

    public void setSkin(@Null Skin skin) {
        this.skin = skin;
    }

    public void setRound(boolean round) {
        this.round = round;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public float getRowHeight(int rowIndex) {
        if (this.rowHeight == null) {
            return 0.0f;
        }
        return this.rowHeight[rowIndex];
    }

    public float getRowMinHeight(int rowIndex) {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.rowMinHeight[rowIndex];
    }

    public float getRowPrefHeight(int rowIndex) {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.rowPrefHeight[rowIndex];
    }

    public float getColumnWidth(int columnIndex) {
        if (this.columnWidth == null) {
            return 0.0f;
        }
        return this.columnWidth[columnIndex];
    }

    public float getColumnMinWidth(int columnIndex) {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.columnMinWidth[columnIndex];
    }

    public float getColumnPrefWidth(int columnIndex) {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.columnPrefWidth[columnIndex];
    }

    private float[] ensureSize(float[] array, int size) {
        if (array == null || array.length < size) {
            return new float[size];
        }
        Arrays.fill(array, 0, size, 0.0f);
        return array;
    }

    private void computeSize() {
        int i2;
        Cell c2;
        int i3;
        float maxWidth;
        this.sizeInvalid = false;
        T[] cells = this.cells.items;
        int cellCount = this.cells.size;
        if (cellCount > 0 && !((Cell)cells[cellCount - 1]).endRow) {
            this.endRow();
            this.implicitEndRow = true;
        }
        int columns = this.columns;
        int rows = this.rows;
        this.columnMinWidth = this.ensureSize(this.columnMinWidth, columns);
        float[] columnMinWidth = this.columnMinWidth;
        this.rowMinHeight = this.ensureSize(this.rowMinHeight, rows);
        float[] rowMinHeight = this.rowMinHeight;
        this.columnPrefWidth = this.ensureSize(this.columnPrefWidth, columns);
        float[] columnPrefWidth = this.columnPrefWidth;
        this.rowPrefHeight = this.ensureSize(this.rowPrefHeight, rows);
        float[] rowPrefHeight = this.rowPrefHeight;
        this.columnWidth = this.ensureSize(this.columnWidth, columns);
        float[] columnWidth = this.columnWidth;
        this.rowHeight = this.ensureSize(this.rowHeight, rows);
        float[] rowHeight = this.rowHeight;
        this.expandWidth = this.ensureSize(this.expandWidth, columns);
        float[] expandWidth = this.expandWidth;
        this.expandHeight = this.ensureSize(this.expandHeight, rows);
        float[] expandHeight = this.expandHeight;
        float spaceRightLast = 0.0f;
        for (int i4 = 0; i4 < cellCount; ++i4) {
            Cell c3 = (Cell)cells[i4];
            int column = c3.column;
            int row = c3.row;
            int colspan = c3.colspan;
            Actor a2 = c3.actor;
            if (c3.expandY != 0 && expandHeight[row] == 0.0f) {
                expandHeight[row] = c3.expandY.intValue();
            }
            if (colspan == 1 && c3.expandX != 0 && expandWidth[column] == 0.0f) {
                expandWidth[column] = c3.expandX.intValue();
            }
            c3.computedPadLeft = c3.padLeft.get(a2) + (column == 0 ? 0.0f : Math.max(0.0f, c3.spaceLeft.get(a2) - spaceRightLast));
            c3.computedPadTop = c3.padTop.get(a2);
            if (c3.cellAboveIndex != -1) {
                Cell above = (Cell)cells[c3.cellAboveIndex];
                c3.computedPadTop += Math.max(0.0f, c3.spaceTop.get(a2) - above.spaceBottom.get(a2));
            }
            float spaceRight = c3.spaceRight.get(a2);
            c3.computedPadRight = c3.padRight.get(a2) + (column + colspan == columns ? 0.0f : spaceRight);
            c3.computedPadBottom = c3.padBottom.get(a2) + (row == rows - 1 ? 0.0f : c3.spaceBottom.get(a2));
            spaceRightLast = spaceRight;
            float prefWidth = c3.prefWidth.get(a2);
            float prefHeight = c3.prefHeight.get(a2);
            float minWidth = c3.minWidth.get(a2);
            float minHeight = c3.minHeight.get(a2);
            maxWidth = c3.maxWidth.get(a2);
            float maxHeight = c3.maxHeight.get(a2);
            if (prefWidth < minWidth) {
                prefWidth = minWidth;
            }
            if (prefHeight < minHeight) {
                prefHeight = minHeight;
            }
            if (maxWidth > 0.0f && prefWidth > maxWidth) {
                prefWidth = maxWidth;
            }
            if (maxHeight > 0.0f && prefHeight > maxHeight) {
                prefHeight = maxHeight;
            }
            if (this.round) {
                minWidth = (float)Math.ceil(minWidth);
                minHeight = (float)Math.ceil(minHeight);
                prefWidth = (float)Math.ceil(prefWidth);
                prefHeight = (float)Math.ceil(prefHeight);
            }
            if (colspan == 1) {
                float hpadding = c3.computedPadLeft + c3.computedPadRight;
                columnPrefWidth[column] = Math.max(columnPrefWidth[column], prefWidth + hpadding);
                columnMinWidth[column] = Math.max(columnMinWidth[column], minWidth + hpadding);
            }
            float vpadding = c3.computedPadTop + c3.computedPadBottom;
            rowPrefHeight[row] = Math.max(rowPrefHeight[row], prefHeight + vpadding);
            rowMinHeight[row] = Math.max(rowMinHeight[row], minHeight + vpadding);
        }
        float uniformMinWidth = 0.0f;
        float uniformMinHeight = 0.0f;
        float uniformPrefWidth = 0.0f;
        float uniformPrefHeight = 0.0f;
        for (i3 = 0; i3 < cellCount; ++i3) {
            int column;
            block28: {
                c2 = (Cell)cells[i3];
                column = c2.column;
                int expandX = c2.expandX;
                if (expandX != 0) {
                    int ii;
                    int nn = column + c2.colspan;
                    for (ii = column; ii < nn; ++ii) {
                        if (expandWidth[ii] == 0.0f) {
                            continue;
                        }
                        break block28;
                    }
                    for (ii = column; ii < nn; ++ii) {
                        expandWidth[ii] = expandX;
                    }
                }
            }
            if (c2.uniformX == Boolean.TRUE && c2.colspan == 1) {
                float hpadding = c2.computedPadLeft + c2.computedPadRight;
                uniformMinWidth = Math.max(uniformMinWidth, columnMinWidth[column] - hpadding);
                uniformPrefWidth = Math.max(uniformPrefWidth, columnPrefWidth[column] - hpadding);
            }
            if (c2.uniformY != Boolean.TRUE) continue;
            float vpadding = c2.computedPadTop + c2.computedPadBottom;
            uniformMinHeight = Math.max(uniformMinHeight, rowMinHeight[c2.row] - vpadding);
            uniformPrefHeight = Math.max(uniformPrefHeight, rowPrefHeight[c2.row] - vpadding);
        }
        if (uniformPrefWidth > 0.0f || uniformPrefHeight > 0.0f) {
            for (i3 = 0; i3 < cellCount; ++i3) {
                c2 = (Cell)cells[i3];
                if (uniformPrefWidth > 0.0f && c2.uniformX == Boolean.TRUE && c2.colspan == 1) {
                    float hpadding = c2.computedPadLeft + c2.computedPadRight;
                    columnMinWidth[c2.column] = uniformMinWidth + hpadding;
                    columnPrefWidth[c2.column] = uniformPrefWidth + hpadding;
                }
                if (!(uniformPrefHeight > 0.0f) || c2.uniformY != Boolean.TRUE) continue;
                float vpadding = c2.computedPadTop + c2.computedPadBottom;
                rowMinHeight[c2.row] = uniformMinHeight + vpadding;
                rowPrefHeight[c2.row] = uniformPrefHeight + vpadding;
            }
        }
        for (i3 = 0; i3 < cellCount; ++i3) {
            int ii;
            float spannedMinWidth;
            c2 = (Cell)cells[i3];
            int colspan = c2.colspan;
            if (colspan == 1) continue;
            int column = c2.column;
            Actor a3 = c2.actor;
            float minWidth = c2.minWidth.get(a3);
            float prefWidth = c2.prefWidth.get(a3);
            maxWidth = c2.maxWidth.get(a3);
            if (prefWidth < minWidth) {
                prefWidth = minWidth;
            }
            if (maxWidth > 0.0f && prefWidth > maxWidth) {
                prefWidth = maxWidth;
            }
            if (this.round) {
                minWidth = (float)Math.ceil(minWidth);
                prefWidth = (float)Math.ceil(prefWidth);
            }
            float spannedPrefWidth = spannedMinWidth = -(c2.computedPadLeft + c2.computedPadRight);
            float totalExpandWidth = 0.0f;
            int nn = ii + colspan;
            for (ii = column; ii < nn; ++ii) {
                spannedMinWidth += columnMinWidth[ii];
                spannedPrefWidth += columnPrefWidth[ii];
                totalExpandWidth += expandWidth[ii];
            }
            float extraMinWidth = Math.max(0.0f, minWidth - spannedMinWidth);
            float extraPrefWidth = Math.max(0.0f, prefWidth - spannedPrefWidth);
            int ii2 = column;
            int nn2 = ii2 + colspan;
            while (ii2 < nn2) {
                float ratio = totalExpandWidth == 0.0f ? 1.0f / (float)colspan : expandWidth[ii2] / totalExpandWidth;
                int n2 = ii2;
                columnMinWidth[n2] = columnMinWidth[n2] + extraMinWidth * ratio;
                int n3 = ii2++;
                columnPrefWidth[n3] = columnPrefWidth[n3] + extraPrefWidth * ratio;
            }
        }
        float hpadding = this.padLeft.get(this) + this.padRight.get(this);
        float vpadding = this.padTop.get(this) + this.padBottom.get(this);
        this.tableMinWidth = hpadding;
        this.tablePrefWidth = hpadding;
        for (i2 = 0; i2 < columns; ++i2) {
            this.tableMinWidth += columnMinWidth[i2];
            this.tablePrefWidth += columnPrefWidth[i2];
        }
        this.tableMinHeight = vpadding;
        this.tablePrefHeight = vpadding;
        for (i2 = 0; i2 < rows; ++i2) {
            this.tableMinHeight += rowMinHeight[i2];
            this.tablePrefHeight += Math.max(rowMinHeight[i2], rowPrefHeight[i2]);
        }
        this.tablePrefWidth = Math.max(this.tableMinWidth, this.tablePrefWidth);
        this.tablePrefHeight = Math.max(this.tableMinHeight, this.tablePrefHeight);
    }

    @Override
    public void layout() {
        int i2;
        float amount;
        int i3;
        float[] rowWeightedHeight;
        float[] columnWeightedWidth;
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float layoutWidth = this.getWidth();
        float layoutHeight = this.getHeight();
        int columns = this.columns;
        int rows = this.rows;
        float[] columnWidth = this.columnWidth;
        float[] rowHeight = this.rowHeight;
        float padLeft = this.padLeft.get(this);
        float hpadding = padLeft + this.padRight.get(this);
        float padTop = this.padTop.get(this);
        float vpadding = padTop + this.padBottom.get(this);
        float totalGrowWidth = this.tablePrefWidth - this.tableMinWidth;
        if (totalGrowWidth == 0.0f) {
            columnWeightedWidth = this.columnMinWidth;
        } else {
            float extraWidth = Math.min(totalGrowWidth, Math.max(0.0f, layoutWidth - this.tableMinWidth));
            Table.columnWeightedWidth = this.ensureSize(Table.columnWeightedWidth, columns);
            columnWeightedWidth = Table.columnWeightedWidth;
            float[] columnMinWidth = this.columnMinWidth;
            float[] columnPrefWidth = this.columnPrefWidth;
            for (int i4 = 0; i4 < columns; ++i4) {
                float growWidth = columnPrefWidth[i4] - columnMinWidth[i4];
                float growRatio = growWidth / totalGrowWidth;
                columnWeightedWidth[i4] = columnMinWidth[i4] + extraWidth * growRatio;
            }
        }
        float totalGrowHeight = this.tablePrefHeight - this.tableMinHeight;
        if (totalGrowHeight == 0.0f) {
            rowWeightedHeight = this.rowMinHeight;
        } else {
            Table.rowWeightedHeight = this.ensureSize(Table.rowWeightedHeight, rows);
            rowWeightedHeight = Table.rowWeightedHeight;
            float extraHeight = Math.min(totalGrowHeight, Math.max(0.0f, layoutHeight - this.tableMinHeight));
            float[] rowMinHeight = this.rowMinHeight;
            float[] rowPrefHeight = this.rowPrefHeight;
            for (int i5 = 0; i5 < rows; ++i5) {
                float growHeight = rowPrefHeight[i5] - rowMinHeight[i5];
                float growRatio = growHeight / totalGrowHeight;
                rowWeightedHeight[i5] = rowMinHeight[i5] + extraHeight * growRatio;
            }
        }
        T[] cells = this.cells.items;
        int cellCount = this.cells.size;
        for (int i6 = 0; i6 < cellCount; ++i6) {
            int ii;
            Cell c2 = (Cell)cells[i6];
            int column = c2.column;
            int row = c2.row;
            Actor a2 = c2.actor;
            float spannedWeightedWidth = 0.0f;
            int colspan = c2.colspan;
            int nn = ii + colspan;
            for (ii = column; ii < nn; ++ii) {
                spannedWeightedWidth += columnWeightedWidth[ii];
            }
            float weightedHeight = rowWeightedHeight[row];
            float prefWidth = c2.prefWidth.get(a2);
            float prefHeight = c2.prefHeight.get(a2);
            float minWidth = c2.minWidth.get(a2);
            float minHeight = c2.minHeight.get(a2);
            float maxWidth = c2.maxWidth.get(a2);
            float maxHeight = c2.maxHeight.get(a2);
            if (prefWidth < minWidth) {
                prefWidth = minWidth;
            }
            if (prefHeight < minHeight) {
                prefHeight = minHeight;
            }
            if (maxWidth > 0.0f && prefWidth > maxWidth) {
                prefWidth = maxWidth;
            }
            if (maxHeight > 0.0f && prefHeight > maxHeight) {
                prefHeight = maxHeight;
            }
            c2.actorWidth = Math.min(spannedWeightedWidth - c2.computedPadLeft - c2.computedPadRight, prefWidth);
            c2.actorHeight = Math.min(weightedHeight - c2.computedPadTop - c2.computedPadBottom, prefHeight);
            if (colspan == 1) {
                columnWidth[column] = Math.max(columnWidth[column], spannedWeightedWidth);
            }
            rowHeight[row] = Math.max(rowHeight[row], weightedHeight);
        }
        float[] expandWidth = this.expandWidth;
        float[] expandHeight = this.expandHeight;
        float totalExpand = 0.0f;
        for (int i7 = 0; i7 < columns; ++i7) {
            totalExpand += expandWidth[i7];
        }
        if (totalExpand > 0.0f) {
            float extra = layoutWidth - hpadding;
            for (int i8 = 0; i8 < columns; ++i8) {
                extra -= columnWidth[i8];
            }
            if (extra > 0.0f) {
                float used = 0.0f;
                int lastIndex = 0;
                for (i3 = 0; i3 < columns; ++i3) {
                    if (expandWidth[i3] == 0.0f) continue;
                    amount = extra * expandWidth[i3] / totalExpand;
                    int n2 = i3;
                    columnWidth[n2] = columnWidth[n2] + amount;
                    used += amount;
                    lastIndex = i3;
                }
                int n3 = lastIndex;
                columnWidth[n3] = columnWidth[n3] + (extra - used);
            }
        }
        totalExpand = 0.0f;
        for (int i9 = 0; i9 < rows; ++i9) {
            totalExpand += expandHeight[i9];
        }
        if (totalExpand > 0.0f) {
            float extra = layoutHeight - vpadding;
            for (int i10 = 0; i10 < rows; ++i10) {
                extra -= rowHeight[i10];
            }
            if (extra > 0.0f) {
                float used = 0.0f;
                int lastIndex = 0;
                for (i3 = 0; i3 < rows; ++i3) {
                    if (expandHeight[i3] == 0.0f) continue;
                    amount = extra * expandHeight[i3] / totalExpand;
                    int n4 = i3;
                    rowHeight[n4] = rowHeight[n4] + amount;
                    used += amount;
                    lastIndex = i3;
                }
                int n5 = lastIndex;
                rowHeight[n5] = rowHeight[n5] + (extra - used);
            }
        }
        for (int i11 = 0; i11 < cellCount; ++i11) {
            int column;
            Cell c3 = (Cell)cells[i11];
            int colspan = c3.colspan;
            if (colspan == 1) continue;
            float extraWidth = 0.0f;
            int nn = column + colspan;
            for (column = c3.column; column < nn; ++column) {
                extraWidth += columnWeightedWidth[column] - columnWidth[column];
            }
            extraWidth -= Math.max(0.0f, c3.computedPadLeft + c3.computedPadRight);
            if (!((extraWidth /= (float)colspan) > 0.0f)) continue;
            column = c3.column;
            nn = column + colspan;
            while (column < nn) {
                int n6 = column++;
                columnWidth[n6] = columnWidth[n6] + extraWidth;
            }
        }
        float tableWidth = hpadding;
        float tableHeight = vpadding;
        for (i2 = 0; i2 < columns; ++i2) {
            tableWidth += columnWidth[i2];
        }
        for (i2 = 0; i2 < rows; ++i2) {
            tableHeight += rowHeight[i2];
        }
        int align = this.align;
        float x2 = padLeft;
        if ((align & 0x10) != 0) {
            x2 += layoutWidth - tableWidth;
        } else if ((align & 8) == 0) {
            x2 += (layoutWidth - tableWidth) / 2.0f;
        }
        float y2 = padTop;
        if ((align & 4) != 0) {
            y2 += layoutHeight - tableHeight;
        } else if ((align & 2) == 0) {
            y2 += (layoutHeight - tableHeight) / 2.0f;
        }
        float currentX = x2;
        float currentY = y2;
        for (int i12 = 0; i12 < cellCount; ++i12) {
            int column;
            Cell c4 = (Cell)cells[i12];
            float spannedCellWidth = 0.0f;
            int nn = column + c4.colspan;
            for (column = c4.column; column < nn; ++column) {
                spannedCellWidth += columnWidth[column];
            }
            spannedCellWidth -= c4.computedPadLeft + c4.computedPadRight;
            currentX += c4.computedPadLeft;
            float fillX = c4.fillX.floatValue();
            float fillY = c4.fillY.floatValue();
            if (fillX > 0.0f) {
                c4.actorWidth = Math.max(spannedCellWidth * fillX, c4.minWidth.get(c4.actor));
                float maxWidth = c4.maxWidth.get(c4.actor);
                if (maxWidth > 0.0f) {
                    c4.actorWidth = Math.min(c4.actorWidth, maxWidth);
                }
            }
            if (fillY > 0.0f) {
                c4.actorHeight = Math.max(rowHeight[c4.row] * fillY - c4.computedPadTop - c4.computedPadBottom, c4.minHeight.get(c4.actor));
                float maxHeight = c4.maxHeight.get(c4.actor);
                if (maxHeight > 0.0f) {
                    c4.actorHeight = Math.min(c4.actorHeight, maxHeight);
                }
            }
            c4.actorX = ((align = c4.align.intValue()) & 8) != 0 ? currentX : ((align & 0x10) != 0 ? currentX + spannedCellWidth - c4.actorWidth : currentX + (spannedCellWidth - c4.actorWidth) / 2.0f);
            c4.actorY = (align & 2) != 0 ? c4.computedPadTop : ((align & 4) != 0 ? rowHeight[c4.row] - c4.actorHeight - c4.computedPadBottom : (rowHeight[c4.row] - c4.actorHeight + c4.computedPadTop - c4.computedPadBottom) / 2.0f);
            c4.actorY = layoutHeight - currentY - c4.actorY - c4.actorHeight;
            if (this.round) {
                c4.actorWidth = (float)Math.ceil(c4.actorWidth);
                c4.actorHeight = (float)Math.ceil(c4.actorHeight);
                c4.actorX = (float)Math.floor(c4.actorX);
                c4.actorY = (float)Math.floor(c4.actorY);
            }
            if (c4.actor != null) {
                c4.actor.setBounds(c4.actorX, c4.actorY, c4.actorWidth, c4.actorHeight);
            }
            if (c4.endRow) {
                currentX = x2;
                currentY += rowHeight[c4.row];
                continue;
            }
            currentX += spannedCellWidth + c4.computedPadRight;
        }
        SnapshotArray<Actor> childrenArray = this.getChildren();
        Actor[] children = (Actor[])childrenArray.items;
        int n7 = childrenArray.size;
        for (int i13 = 0; i13 < n7; ++i13) {
            Actor child = children[i13];
            if (!(child instanceof Layout)) continue;
            ((Layout)((Object)child)).validate();
        }
        if (this.debug != Debug.none) {
            this.addDebugRects(x2, y2, tableWidth - hpadding, tableHeight - vpadding);
        }
    }

    private void addDebugRects(float currentX, float currentY, float width, float height) {
        this.clearDebugRects();
        if (this.debug == Debug.table || this.debug == Debug.all) {
            this.addDebugRect(0.0f, 0.0f, this.getWidth(), this.getHeight(), debugTableColor);
            this.addDebugRect(currentX, this.getHeight() - currentY, width, -height, debugTableColor);
        }
        float x2 = currentX;
        int n2 = this.cells.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            int column;
            Cell c2 = this.cells.get(i2);
            if (this.debug == Debug.actor || this.debug == Debug.all) {
                this.addDebugRect(c2.actorX, c2.actorY, c2.actorWidth, c2.actorHeight, debugActorColor);
            }
            float spannedCellWidth = 0.0f;
            int nn = column + c2.colspan;
            for (column = c2.column; column < nn; ++column) {
                spannedCellWidth += this.columnWidth[column];
            }
            spannedCellWidth -= c2.computedPadLeft + c2.computedPadRight;
            currentX += c2.computedPadLeft;
            if (this.debug == Debug.cell || this.debug == Debug.all) {
                float h2 = this.rowHeight[c2.row] - c2.computedPadTop - c2.computedPadBottom;
                float y2 = currentY + c2.computedPadTop;
                this.addDebugRect(currentX, this.getHeight() - y2, spannedCellWidth, -h2, debugCellColor);
            }
            if (c2.endRow) {
                currentX = x2;
                currentY += this.rowHeight[c2.row];
                continue;
            }
            currentX += spannedCellWidth + c2.computedPadRight;
        }
    }

    private void clearDebugRects() {
        if (this.debugRects == null) {
            this.debugRects = new Array();
        }
        DebugRect.pool.freeAll(this.debugRects);
        this.debugRects.clear();
    }

    private void addDebugRect(float x2, float y2, float w2, float h2, Color color) {
        DebugRect rect = DebugRect.pool.obtain();
        rect.color = color;
        rect.set(x2, y2, w2, h2);
        this.debugRects.add(rect);
    }

    @Override
    public void drawDebug(ShapeRenderer shapes) {
        if (this.isTransform()) {
            this.applyTransform(shapes, this.computeTransform());
            this.drawDebugRects(shapes);
            if (this.clip) {
                shapes.flush();
                float x2 = 0.0f;
                float y2 = 0.0f;
                float width = this.getWidth();
                float height = this.getHeight();
                if (this.background != null) {
                    x2 = this.padLeft.get(this);
                    y2 = this.padBottom.get(this);
                    width -= x2 + this.padRight.get(this);
                    height -= y2 + this.padTop.get(this);
                }
                if (this.clipBegin(x2, y2, width, height)) {
                    this.drawDebugChildren(shapes);
                    this.clipEnd();
                }
            } else {
                this.drawDebugChildren(shapes);
            }
            this.resetTransform(shapes);
        } else {
            this.drawDebugRects(shapes);
            super.drawDebug(shapes);
        }
    }

    @Override
    protected void drawDebugBounds(ShapeRenderer shapes) {
    }

    private void drawDebugRects(ShapeRenderer shapes) {
        if (this.debugRects == null || !this.getDebug()) {
            return;
        }
        shapes.set(ShapeRenderer.ShapeType.Line);
        if (this.getStage() != null) {
            shapes.setColor(this.getStage().getDebugColor());
        }
        float x2 = 0.0f;
        float y2 = 0.0f;
        if (!this.isTransform()) {
            x2 = this.getX();
            y2 = this.getY();
        }
        int n2 = this.debugRects.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            DebugRect debugRect = this.debugRects.get(i2);
            shapes.setColor(debugRect.color);
            shapes.rect(x2 + debugRect.x, y2 + debugRect.y, debugRect.width, debugRect.height);
        }
    }

    @Null
    public Skin getSkin() {
        return this.skin;
    }

    static {
        backgroundTop = new Value(){

            @Override
            public float get(@Null Actor context) {
                Drawable background = ((Table)context).background;
                return background == null ? 0.0f : background.getTopHeight();
            }
        };
        backgroundLeft = new Value(){

            @Override
            public float get(@Null Actor context) {
                Drawable background = ((Table)context).background;
                return background == null ? 0.0f : background.getLeftWidth();
            }
        };
        backgroundBottom = new Value(){

            @Override
            public float get(@Null Actor context) {
                Drawable background = ((Table)context).background;
                return background == null ? 0.0f : background.getBottomHeight();
            }
        };
        backgroundRight = new Value(){

            @Override
            public float get(@Null Actor context) {
                Drawable background = ((Table)context).background;
                return background == null ? 0.0f : background.getRightWidth();
            }
        };
    }

    public static enum Debug {
        none,
        all,
        table,
        cell,
        actor;

    }

    public static class DebugRect
    extends Rectangle {
        static Pool<DebugRect> pool = Pools.get(DebugRect.class);
        Color color;
    }
}

