/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Pools;

public class ProgressBar
extends Widget
implements Disableable {
    private ProgressBarStyle style;
    float min;
    float max;
    float stepSize;
    private float value;
    private float animateFromValue;
    float position;
    final boolean vertical;
    private float animateDuration;
    private float animateTime;
    private Interpolation animateInterpolation = Interpolation.linear;
    private Interpolation visualInterpolation = Interpolation.linear;
    boolean disabled;
    private boolean round = true;
    private boolean programmaticChangeEvents = true;

    public ProgressBar(float min, float max, float stepSize, boolean vertical, Skin skin) {
        this(min, max, stepSize, vertical, skin.get("default-" + (vertical ? "vertical" : "horizontal"), ProgressBarStyle.class));
    }

    public ProgressBar(float min, float max, float stepSize, boolean vertical, Skin skin, String styleName) {
        this(min, max, stepSize, vertical, skin.get(styleName, ProgressBarStyle.class));
    }

    public ProgressBar(float min, float max, float stepSize, boolean vertical, ProgressBarStyle style) {
        if (min > max) {
            throw new IllegalArgumentException("max must be > min. min,max: " + min + ", " + max);
        }
        if (stepSize <= 0.0f) {
            throw new IllegalArgumentException("stepSize must be > 0: " + stepSize);
        }
        this.setStyle(style);
        this.min = min;
        this.max = max;
        this.stepSize = stepSize;
        this.vertical = vertical;
        this.value = min;
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    public void setStyle(ProgressBarStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        this.invalidateHierarchy();
    }

    public ProgressBarStyle getStyle() {
        return this.style;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.animateTime > 0.0f) {
            this.animateTime -= delta;
            Stage stage = this.getStage();
            if (stage != null && stage.getActionsRequestRendering()) {
                Gdx.graphics.requestRendering();
            }
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        ProgressBarStyle style = this.style;
        boolean disabled = this.disabled;
        Drawable knob = style.knob;
        Drawable currentKnob = this.getKnobDrawable();
        Drawable bg2 = this.getBackgroundDrawable();
        Drawable knobBefore = this.getKnobBeforeDrawable();
        Drawable knobAfter = this.getKnobAfterDrawable();
        Color color = this.getColor();
        float x2 = this.getX();
        float y2 = this.getY();
        float width = this.getWidth();
        float height = this.getHeight();
        float knobHeight = knob == null ? 0.0f : knob.getMinHeight();
        float knobWidth = knob == null ? 0.0f : knob.getMinWidth();
        float percent = this.getVisualPercent();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        if (this.vertical) {
            float bgTopHeight = 0.0f;
            float bgBottomHeight = 0.0f;
            if (bg2 != null) {
                this.drawRound(batch, bg2, x2 + (width - bg2.getMinWidth()) * 0.5f, y2, bg2.getMinWidth(), height);
                bgTopHeight = bg2.getTopHeight();
                bgBottomHeight = bg2.getBottomHeight();
                height -= bgTopHeight + bgBottomHeight;
            }
            float total = height - knobHeight;
            float beforeHeight = MathUtils.clamp(total * percent, 0.0f, total);
            this.position = bgBottomHeight + beforeHeight;
            float knobHeightHalf = knobHeight * 0.5f;
            if (knobBefore != null) {
                this.drawRound(batch, knobBefore, x2 + (width - knobBefore.getMinWidth()) * 0.5f, y2 + bgBottomHeight, knobBefore.getMinWidth(), beforeHeight + knobHeightHalf);
            }
            if (knobAfter != null) {
                this.drawRound(batch, knobAfter, x2 + (width - knobAfter.getMinWidth()) * 0.5f, y2 + this.position + knobHeightHalf, knobAfter.getMinWidth(), total - (this.round ? (float)Math.ceil(beforeHeight - knobHeightHalf) : beforeHeight - knobHeightHalf));
            }
            if (currentKnob != null) {
                float w2 = currentKnob.getMinWidth();
                float h2 = currentKnob.getMinHeight();
                this.drawRound(batch, currentKnob, x2 + (width - w2) * 0.5f, y2 + this.position + (knobHeight - h2) * 0.5f, w2, h2);
            }
        } else {
            float bgLeftWidth = 0.0f;
            float bgRightWidth = 0.0f;
            if (bg2 != null) {
                this.drawRound(batch, bg2, x2, Math.round(y2 + (height - bg2.getMinHeight()) * 0.5f), width, Math.round(bg2.getMinHeight()));
                bgLeftWidth = bg2.getLeftWidth();
                bgRightWidth = bg2.getRightWidth();
                width -= bgLeftWidth + bgRightWidth;
            }
            float total = width - knobWidth;
            float beforeWidth = MathUtils.clamp(total * percent, 0.0f, total);
            this.position = bgLeftWidth + beforeWidth;
            float knobWidthHalf = knobWidth * 0.5f;
            if (knobBefore != null) {
                this.drawRound(batch, knobBefore, x2 + bgLeftWidth, y2 + (height - knobBefore.getMinHeight()) * 0.5f, beforeWidth + knobWidthHalf, knobBefore.getMinHeight());
            }
            if (knobAfter != null) {
                this.drawRound(batch, knobAfter, x2 + this.position + knobWidthHalf, y2 + (height - knobAfter.getMinHeight()) * 0.5f, total - (this.round ? (float)Math.ceil(beforeWidth - knobWidthHalf) : beforeWidth - knobWidthHalf), knobAfter.getMinHeight());
            }
            if (currentKnob != null) {
                float w3 = currentKnob.getMinWidth();
                float h3 = currentKnob.getMinHeight();
                this.drawRound(batch, currentKnob, x2 + this.position + (knobWidth - w3) * 0.5f, y2 + (height - h3) * 0.5f, w3, h3);
            }
        }
    }

    private void drawRound(Batch batch, Drawable drawable, float x2, float y2, float w2, float h2) {
        if (this.round) {
            x2 = (float)Math.floor(x2);
            y2 = (float)Math.floor(y2);
            w2 = (float)Math.ceil(w2);
            h2 = (float)Math.ceil(h2);
        }
        drawable.draw(batch, x2, y2, w2, h2);
    }

    public float getValue() {
        return this.value;
    }

    public float getVisualValue() {
        if (this.animateTime > 0.0f) {
            return this.animateInterpolation.apply(this.animateFromValue, this.value, 1.0f - this.animateTime / this.animateDuration);
        }
        return this.value;
    }

    public void updateVisualValue() {
        this.animateTime = 0.0f;
    }

    public float getPercent() {
        if (this.min == this.max) {
            return 0.0f;
        }
        return (this.value - this.min) / (this.max - this.min);
    }

    public float getVisualPercent() {
        if (this.min == this.max) {
            return 0.0f;
        }
        return this.visualInterpolation.apply((this.getVisualValue() - this.min) / (this.max - this.min));
    }

    @Null
    protected Drawable getBackgroundDrawable() {
        if (this.disabled && this.style.disabledBackground != null) {
            return this.style.disabledBackground;
        }
        return this.style.background;
    }

    @Null
    protected Drawable getKnobDrawable() {
        if (this.disabled && this.style.disabledKnob != null) {
            return this.style.disabledKnob;
        }
        return this.style.knob;
    }

    protected Drawable getKnobBeforeDrawable() {
        if (this.disabled && this.style.disabledKnobBefore != null) {
            return this.style.disabledKnobBefore;
        }
        return this.style.knobBefore;
    }

    protected Drawable getKnobAfterDrawable() {
        if (this.disabled && this.style.disabledKnobAfter != null) {
            return this.style.disabledKnobAfter;
        }
        return this.style.knobAfter;
    }

    protected float getKnobPosition() {
        return this.position;
    }

    public boolean setValue(float value) {
        float oldValue;
        if ((value = this.clamp(this.round(value))) == (oldValue = this.value)) {
            return false;
        }
        float oldVisualValue = this.getVisualValue();
        this.value = value;
        if (this.programmaticChangeEvents) {
            ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
            boolean cancelled = this.fire(changeEvent);
            Pools.free(changeEvent);
            if (cancelled) {
                this.value = oldValue;
                return false;
            }
        }
        if (this.animateDuration > 0.0f) {
            this.animateFromValue = oldVisualValue;
            this.animateTime = this.animateDuration;
        }
        return true;
    }

    protected float round(float value) {
        return (float)Math.round(value / this.stepSize) * this.stepSize;
    }

    protected float clamp(float value) {
        return MathUtils.clamp(value, this.min, this.max);
    }

    public void setRange(float min, float max) {
        if (min > max) {
            throw new IllegalArgumentException("min must be <= max: " + min + " <= " + max);
        }
        this.min = min;
        this.max = max;
        if (this.value < min) {
            this.setValue(min);
        } else if (this.value > max) {
            this.setValue(max);
        }
    }

    public void setStepSize(float stepSize) {
        if (stepSize <= 0.0f) {
            throw new IllegalArgumentException("steps must be > 0: " + stepSize);
        }
        this.stepSize = stepSize;
    }

    @Override
    public float getPrefWidth() {
        if (this.vertical) {
            Drawable knob = this.style.knob;
            Drawable bg2 = this.getBackgroundDrawable();
            return Math.max(knob == null ? 0.0f : knob.getMinWidth(), bg2 == null ? 0.0f : bg2.getMinWidth());
        }
        return 140.0f;
    }

    @Override
    public float getPrefHeight() {
        if (this.vertical) {
            return 140.0f;
        }
        Drawable knob = this.style.knob;
        Drawable bg2 = this.getBackgroundDrawable();
        return Math.max(knob == null ? 0.0f : knob.getMinHeight(), bg2 == null ? 0.0f : bg2.getMinHeight());
    }

    public float getMinValue() {
        return this.min;
    }

    public float getMaxValue() {
        return this.max;
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setAnimateDuration(float duration) {
        this.animateDuration = duration;
    }

    public void setAnimateInterpolation(Interpolation animateInterpolation) {
        if (animateInterpolation == null) {
            throw new IllegalArgumentException("animateInterpolation cannot be null.");
        }
        this.animateInterpolation = animateInterpolation;
    }

    public void setVisualInterpolation(Interpolation interpolation) {
        this.visualInterpolation = interpolation;
    }

    public void setRound(boolean round) {
        this.round = round;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isAnimating() {
        return this.animateTime > 0.0f;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setProgrammaticChangeEvents(boolean programmaticChangeEvents) {
        this.programmaticChangeEvents = programmaticChangeEvents;
    }

    public static class ProgressBarStyle {
        @Null
        public Drawable background;
        @Null
        public Drawable disabledBackground;
        @Null
        public Drawable knob;
        @Null
        public Drawable disabledKnob;
        @Null
        public Drawable knobBefore;
        @Null
        public Drawable disabledKnobBefore;
        @Null
        public Drawable knobAfter;
        @Null
        public Drawable disabledKnobAfter;

        public ProgressBarStyle() {
        }

        public ProgressBarStyle(@Null Drawable background, @Null Drawable knob) {
            this.background = background;
            this.knob = knob;
        }

        public ProgressBarStyle(ProgressBarStyle style) {
            this.background = style.background;
            this.disabledBackground = style.disabledBackground;
            this.knob = style.knob;
            this.disabledKnob = style.disabledKnob;
            this.knobBefore = style.knobBefore;
            this.disabledKnobBefore = style.disabledKnobBefore;
            this.knobAfter = style.knobAfter;
            this.disabledKnobAfter = style.disabledKnobAfter;
        }
    }
}

