/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.scenes.scene2d.actions.TemporalAction;

public class MoveToAction
extends TemporalAction {
    private float startX;
    private float startY;
    private float endX;
    private float endY;
    private int alignment = 12;

    @Override
    protected void begin() {
        this.startX = this.target.getX(this.alignment);
        this.startY = this.target.getY(this.alignment);
    }

    @Override
    protected void update(float percent) {
        float y2;
        float x2;
        if (percent == 0.0f) {
            x2 = this.startX;
            y2 = this.startY;
        } else if (percent == 1.0f) {
            x2 = this.endX;
            y2 = this.endY;
        } else {
            x2 = this.startX + (this.endX - this.startX) * percent;
            y2 = this.startY + (this.endY - this.startY) * percent;
        }
        this.target.setPosition(x2, y2, this.alignment);
    }

    @Override
    public void reset() {
        super.reset();
        this.alignment = 12;
    }

    public void setStartPosition(float x2, float y2) {
        this.startX = x2;
        this.startY = y2;
    }

    public void setPosition(float x2, float y2) {
        this.endX = x2;
        this.endY = y2;
    }

    public void setPosition(float x2, float y2, int alignment) {
        this.endX = x2;
        this.endY = y2;
        this.alignment = alignment;
    }

    public float getX() {
        return this.endX;
    }

    public void setX(float x2) {
        this.endX = x2;
    }

    public float getY() {
        return this.endY;
    }

    public void setY(float y2) {
        this.endY = y2;
    }

    public float getStartX() {
        return this.startX;
    }

    public float getStartY() {
        return this.startY;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }
}

