/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Shape2D;
import com.badlogic.gdx.math.Vector2;

public class Polyline
implements Shape2D {
    private float[] localVertices;
    private float[] worldVertices;
    private float x;
    private float y;
    private float originX;
    private float originY;
    private float rotation;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float length;
    private float scaledLength;
    private boolean calculateScaledLength = true;
    private boolean calculateLength = true;
    private boolean dirty = true;
    private Rectangle bounds;

    public Polyline() {
        this.localVertices = new float[0];
    }

    public Polyline(float[] vertices) {
        if (vertices.length < 4) {
            throw new IllegalArgumentException("polylines must contain at least 2 points.");
        }
        this.localVertices = vertices;
    }

    public float[] getVertices() {
        return this.localVertices;
    }

    public float[] getTransformedVertices() {
        if (!this.dirty) {
            return this.worldVertices;
        }
        this.dirty = false;
        float[] localVertices = this.localVertices;
        if (this.worldVertices == null || this.worldVertices.length < localVertices.length) {
            this.worldVertices = new float[localVertices.length];
        }
        float[] worldVertices = this.worldVertices;
        float positionX = this.x;
        float positionY = this.y;
        float originX = this.originX;
        float originY = this.originY;
        float scaleX = this.scaleX;
        float scaleY = this.scaleY;
        boolean scale = scaleX != 1.0f || scaleY != 1.0f;
        float rotation = this.rotation;
        float cos = MathUtils.cosDeg(rotation);
        float sin = MathUtils.sinDeg(rotation);
        int n2 = localVertices.length;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            float x2 = localVertices[i2] - originX;
            float y2 = localVertices[i2 + 1] - originY;
            if (scale) {
                x2 *= scaleX;
                y2 *= scaleY;
            }
            if (rotation != 0.0f) {
                float oldX = x2;
                x2 = cos * x2 - sin * y2;
                y2 = sin * oldX + cos * y2;
            }
            worldVertices[i2] = positionX + x2 + originX;
            worldVertices[i2 + 1] = positionY + y2 + originY;
        }
        return worldVertices;
    }

    public float getLength() {
        if (!this.calculateLength) {
            return this.length;
        }
        this.calculateLength = false;
        this.length = 0.0f;
        int n2 = this.localVertices.length - 2;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            float x2 = this.localVertices[i2 + 2] - this.localVertices[i2];
            float y2 = this.localVertices[i2 + 1] - this.localVertices[i2 + 3];
            this.length += (float)Math.sqrt(x2 * x2 + y2 * y2);
        }
        return this.length;
    }

    public float getScaledLength() {
        if (!this.calculateScaledLength) {
            return this.scaledLength;
        }
        this.calculateScaledLength = false;
        this.scaledLength = 0.0f;
        int n2 = this.localVertices.length - 2;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            float x2 = this.localVertices[i2 + 2] * this.scaleX - this.localVertices[i2] * this.scaleX;
            float y2 = this.localVertices[i2 + 1] * this.scaleY - this.localVertices[i2 + 3] * this.scaleY;
            this.scaledLength += (float)Math.sqrt(x2 * x2 + y2 * y2);
        }
        return this.scaledLength;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getOriginX() {
        return this.originX;
    }

    public float getOriginY() {
        return this.originY;
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setOrigin(float originX, float originY) {
        this.originX = originX;
        this.originY = originY;
        this.dirty = true;
    }

    public void setPosition(float x2, float y2) {
        this.x = x2;
        this.y = y2;
        this.dirty = true;
    }

    public void setVertices(float[] vertices) {
        if (vertices.length < 4) {
            throw new IllegalArgumentException("polylines must contain at least 2 points.");
        }
        this.localVertices = vertices;
        this.dirty = true;
    }

    public void setRotation(float degrees) {
        this.rotation = degrees;
        this.dirty = true;
    }

    public void rotate(float degrees) {
        this.rotation += degrees;
        this.dirty = true;
    }

    public void setScale(float scaleX, float scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.dirty = true;
        this.calculateScaledLength = true;
    }

    public void scale(float amount) {
        this.scaleX += amount;
        this.scaleY += amount;
        this.dirty = true;
        this.calculateScaledLength = true;
    }

    public void calculateLength() {
        this.calculateLength = true;
    }

    public void calculateScaledLength() {
        this.calculateScaledLength = true;
    }

    public void dirty() {
        this.dirty = true;
    }

    public void translate(float x2, float y2) {
        this.x += x2;
        this.y += y2;
        this.dirty = true;
    }

    public Rectangle getBoundingRectangle() {
        float[] vertices = this.getTransformedVertices();
        float minX = vertices[0];
        float minY = vertices[1];
        float maxX = vertices[0];
        float maxY = vertices[1];
        int numFloats = vertices.length;
        for (int i2 = 2; i2 < numFloats; i2 += 2) {
            minX = minX > vertices[i2] ? vertices[i2] : minX;
            minY = minY > vertices[i2 + 1] ? vertices[i2 + 1] : minY;
            maxX = maxX < vertices[i2] ? vertices[i2] : maxX;
            maxY = maxY < vertices[i2 + 1] ? vertices[i2 + 1] : maxY;
        }
        if (this.bounds == null) {
            this.bounds = new Rectangle();
        }
        this.bounds.x = minX;
        this.bounds.y = minY;
        this.bounds.width = maxX - minX;
        this.bounds.height = maxY - minY;
        return this.bounds;
    }

    @Override
    public boolean contains(Vector2 point) {
        return false;
    }

    @Override
    public boolean contains(float x2, float y2) {
        return false;
    }
}

