/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.RandomXS128;
import java.util.Random;

public final class MathUtils {
    public static final float nanoToSec = 1.0E-9f;
    public static final float FLOAT_ROUNDING_ERROR = 1.0E-6f;
    public static final float PI = (float)Math.PI;
    public static final float PI2 = (float)Math.PI * 2;
    public static final float HALF_PI = 1.5707964f;
    public static final float E = (float)Math.E;
    private static final int SIN_BITS = 14;
    private static final int SIN_MASK = 16383;
    private static final int SIN_COUNT = 16384;
    private static final float radFull = (float)Math.PI * 2;
    private static final float degFull = 360.0f;
    private static final float radToIndex = 2607.5945f;
    private static final float degToIndex = 45.511112f;
    public static final float radiansToDegrees = 57.295776f;
    public static final float radDeg = 57.295776f;
    public static final float degreesToRadians = (float)Math.PI / 180;
    public static final float degRad = (float)Math.PI / 180;
    public static Random random = new RandomXS128();
    private static final int BIG_ENOUGH_INT = 16384;
    private static final double BIG_ENOUGH_FLOOR = 16384.0;
    private static final double CEIL = 0.9999999;
    private static final double BIG_ENOUGH_CEIL = 16384.999999999996;
    private static final double BIG_ENOUGH_ROUND = 16384.5;

    private MathUtils() {
    }

    public static float sin(float radians) {
        return Sin.table[(int)(radians * 2607.5945f) & 0x3FFF];
    }

    public static float cos(float radians) {
        return Sin.table[(int)((radians + 1.5707964f) * 2607.5945f) & 0x3FFF];
    }

    public static float sinDeg(float degrees) {
        return Sin.table[(int)(degrees * 45.511112f) & 0x3FFF];
    }

    public static float cosDeg(float degrees) {
        return Sin.table[(int)((degrees + 90.0f) * 45.511112f) & 0x3FFF];
    }

    public static float tan(float radians) {
        radians /= (float)Math.PI;
        radians += 0.5f;
        radians = (float)((double)radians - Math.floor(radians));
        radians -= 0.5f;
        float x2 = (radians *= (float)Math.PI) * radians;
        float x4 = x2 * x2;
        return radians * (0.0010582011f * x4 - 0.11111111f * x2 + 1.0f) / (0.015873017f * x4 - 0.44444445f * x2 + 1.0f);
    }

    public static float tanDeg(float degrees) {
        degrees *= 0.0055555557f;
        degrees += 0.5f;
        degrees = (float)((double)degrees - Math.floor(degrees));
        degrees -= 0.5f;
        float x2 = (degrees *= (float)Math.PI) * degrees;
        float x4 = x2 * x2;
        return degrees * (0.0010582011f * x4 - 0.11111111f * x2 + 1.0f) / (0.015873017f * x4 - 0.44444445f * x2 + 1.0f);
    }

    public static float atanUnchecked(double i2) {
        double n2 = Math.abs(i2);
        double c2 = (n2 - 1.0) / (n2 + 1.0);
        double c22 = c2 * c2;
        double c3 = c2 * c22;
        double c5 = c3 * c22;
        double c7 = c5 * c22;
        double c9 = c7 * c22;
        double c11 = c9 * c22;
        return (float)(Math.signum(i2) * (0.7853981633974483 + (0.99997726 * c2 - 0.33262347 * c3 + 0.19354346 * c5 - 0.11643287 * c7 + 0.05265332 * c9 - 0.0117212 * c11)));
    }

    public static float atan2(float y2, float x2) {
        float n2 = y2 / x2;
        if (n2 != n2) {
            n2 = y2 == x2 ? 1.0f : -1.0f;
        } else if (n2 - n2 != n2 - n2) {
            x2 = 0.0f;
        }
        if (x2 > 0.0f) {
            return MathUtils.atanUnchecked(n2);
        }
        if (x2 < 0.0f) {
            if (y2 >= 0.0f) {
                return MathUtils.atanUnchecked(n2) + (float)Math.PI;
            }
            return MathUtils.atanUnchecked(n2) - (float)Math.PI;
        }
        if (y2 > 0.0f) {
            return x2 + 1.5707964f;
        }
        if (y2 < 0.0f) {
            return x2 - 1.5707964f;
        }
        return x2 + y2;
    }

    public static double atanUncheckedDeg(double i2) {
        double n2 = Math.abs(i2);
        double c2 = (n2 - 1.0) / (n2 + 1.0);
        double c22 = c2 * c2;
        double c3 = c2 * c22;
        double c5 = c3 * c22;
        double c7 = c5 * c22;
        double c9 = c7 * c22;
        double c11 = c9 * c22;
        return Math.signum(i2) * (45.0 + (57.2944766070562 * c2 - 19.05792099799635 * c3 + 11.089223410359068 * c5 - 6.6711120475953765 * c7 + 3.016813013351768 * c9 - 0.6715752908287405 * c11));
    }

    public static float atan2Deg(float y2, float x2) {
        float n2 = y2 / x2;
        if (n2 != n2) {
            n2 = y2 == x2 ? 1.0f : -1.0f;
        } else if (n2 - n2 != n2 - n2) {
            x2 = 0.0f;
        }
        if (x2 > 0.0f) {
            return (float)MathUtils.atanUncheckedDeg(n2);
        }
        if (x2 < 0.0f) {
            if (y2 >= 0.0f) {
                return (float)(MathUtils.atanUncheckedDeg(n2) + 180.0);
            }
            return (float)(MathUtils.atanUncheckedDeg(n2) - 180.0);
        }
        if (y2 > 0.0f) {
            return x2 + 90.0f;
        }
        if (y2 < 0.0f) {
            return x2 - 90.0f;
        }
        return x2 + y2;
    }

    public static float atan2Deg360(float y2, float x2) {
        float n2 = y2 / x2;
        if (n2 != n2) {
            n2 = y2 == x2 ? 1.0f : -1.0f;
        } else if (n2 - n2 != n2 - n2) {
            x2 = 0.0f;
        }
        if (x2 > 0.0f) {
            if (y2 >= 0.0f) {
                return (float)MathUtils.atanUncheckedDeg(n2);
            }
            return (float)(MathUtils.atanUncheckedDeg(n2) + 360.0);
        }
        if (x2 < 0.0f) {
            return (float)(MathUtils.atanUncheckedDeg(n2) + 180.0);
        }
        if (y2 > 0.0f) {
            return x2 + 90.0f;
        }
        if (y2 < 0.0f) {
            return x2 + 270.0f;
        }
        return x2 + y2;
    }

    public static float acos(float a2) {
        float a22 = a2 * a2;
        float a3 = a2 * a22;
        if (a2 >= 0.0f) {
            return (float)Math.sqrt(1.0f - a2) * (1.5707288f - 0.2121144f * a2 + 0.074261f * a22 - 0.0187293f * a3);
        }
        return (float)Math.PI - (float)Math.sqrt(1.0f + a2) * (1.5707288f + 0.2121144f * a2 + 0.074261f * a22 + 0.0187293f * a3);
    }

    public static float asin(float a2) {
        float a22 = a2 * a2;
        float a3 = a2 * a22;
        if (a2 >= 0.0f) {
            return 1.5707964f - (float)Math.sqrt(1.0f - a2) * (1.5707288f - 0.2121144f * a2 + 0.074261f * a22 - 0.0187293f * a3);
        }
        return -1.5707964f + (float)Math.sqrt(1.0f + a2) * (1.5707288f + 0.2121144f * a2 + 0.074261f * a22 + 0.0187293f * a3);
    }

    public static float atan(float i2) {
        double n2 = Math.min((double)Math.abs(i2), Double.MAX_VALUE);
        double c2 = (n2 - 1.0) / (n2 + 1.0);
        double c22 = c2 * c2;
        double c3 = c2 * c22;
        double c5 = c3 * c22;
        double c7 = c5 * c22;
        double c9 = c7 * c22;
        double c11 = c9 * c22;
        return Math.signum(i2) * (float)(0.7853981633974483 + (0.99997726 * c2 - 0.33262347 * c3 + 0.19354346 * c5 - 0.11643287 * c7 + 0.05265332 * c9 - 0.0117212 * c11));
    }

    public static float asinDeg(float a2) {
        float a22 = a2 * a2;
        float a3 = a2 * a22;
        if (a2 >= 0.0f) {
            return 90.0f - (float)Math.sqrt(1.0f - a2) * (89.99613f - 12.15326f * a2 + 4.254842f * a22 - 1.0731099f * a3);
        }
        return (float)Math.sqrt(1.0f + a2) * (89.99613f + 12.15326f * a2 + 4.254842f * a22 + 1.0731099f * a3) - 90.0f;
    }

    public static float acosDeg(float a2) {
        float a22 = a2 * a2;
        float a3 = a2 * a22;
        if (a2 >= 0.0f) {
            return (float)Math.sqrt(1.0f - a2) * (89.99613f - 12.153259f * a2 + 4.254842f * a22 - 1.0731097f * a3);
        }
        return 180.0f - (float)Math.sqrt(1.0f + a2) * (89.99613f + 12.153259f * a2 + 4.254842f * a22 + 1.0731097f * a3);
    }

    public static float atanDeg(float i2) {
        double n2 = Math.min((double)Math.abs(i2), Double.MAX_VALUE);
        double c2 = (n2 - 1.0) / (n2 + 1.0);
        double c22 = c2 * c2;
        double c3 = c2 * c22;
        double c5 = c3 * c22;
        double c7 = c5 * c22;
        double c9 = c7 * c22;
        double c11 = c9 * c22;
        return (float)((double)Math.signum(i2) * (45.0 + (57.2944766070562 * c2 - 19.05792099799635 * c3 + 11.089223410359068 * c5 - 6.6711120475953765 * c7 + 3.016813013351768 * c9 - 0.6715752908287405 * c11)));
    }

    public static int random(int range) {
        return random.nextInt(range + 1);
    }

    public static int random(int start, int end) {
        return start + random.nextInt(end - start + 1);
    }

    public static long random(long range) {
        return MathUtils.random(0L, range);
    }

    public static long random(long start, long end) {
        long rand = random.nextLong();
        if (end < start) {
            long t2 = end;
            end = start;
            start = t2;
        }
        long bound = end - start + 1L;
        long randLow = rand & 0xFFFFFFFFL;
        long boundLow = bound & 0xFFFFFFFFL;
        long randHigh = rand >>> 32;
        long boundHigh = bound >>> 32;
        return start + (randHigh * boundLow >>> 32) + (randLow * boundHigh >>> 32) + randHigh * boundHigh;
    }

    public static boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static boolean randomBoolean(float chance) {
        return MathUtils.random() < chance;
    }

    public static float random() {
        return random.nextFloat();
    }

    public static float random(float range) {
        return random.nextFloat() * range;
    }

    public static float random(float start, float end) {
        return start + random.nextFloat() * (end - start);
    }

    public static int randomSign() {
        return 1 | random.nextInt() >> 31;
    }

    public static float randomTriangular() {
        return random.nextFloat() - random.nextFloat();
    }

    public static float randomTriangular(float max) {
        return (random.nextFloat() - random.nextFloat()) * max;
    }

    public static float randomTriangular(float min, float max) {
        return MathUtils.randomTriangular(min, max, (min + max) * 0.5f);
    }

    public static float randomTriangular(float min, float max, float mode) {
        float d2;
        float u2 = random.nextFloat();
        if (u2 <= (mode - min) / (d2 = max - min)) {
            return min + (float)Math.sqrt(u2 * d2 * (mode - min));
        }
        return max - (float)Math.sqrt((1.0f - u2) * d2 * (max - mode));
    }

    public static int nextPowerOfTwo(int value) {
        if (value == 0) {
            return 1;
        }
        --value;
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        value |= value >> 16;
        return value + 1;
    }

    public static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static short clamp(short value, short min, short max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static long clamp(long value, long min, long max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float lerp(float fromValue, float toValue, float progress) {
        return fromValue + (toValue - fromValue) * progress;
    }

    public static float norm(float rangeStart, float rangeEnd, float value) {
        return (value - rangeStart) / (rangeEnd - rangeStart);
    }

    public static float map(float inRangeStart, float inRangeEnd, float outRangeStart, float outRangeEnd, float value) {
        return outRangeStart + (value - inRangeStart) * (outRangeEnd - outRangeStart) / (inRangeEnd - inRangeStart);
    }

    public static float lerpAngle(float fromRadians, float toRadians, float progress) {
        float delta = ((toRadians - fromRadians) % ((float)Math.PI * 2) + (float)Math.PI * 2 + (float)Math.PI) % ((float)Math.PI * 2) - (float)Math.PI;
        return ((fromRadians + delta * progress) % ((float)Math.PI * 2) + (float)Math.PI * 2) % ((float)Math.PI * 2);
    }

    public static float lerpAngleDeg(float fromDegrees, float toDegrees, float progress) {
        float delta = ((toDegrees - fromDegrees) % 360.0f + 360.0f + 180.0f) % 360.0f - 180.0f;
        return ((fromDegrees + delta * progress) % 360.0f + 360.0f) % 360.0f;
    }

    public static int floor(float value) {
        return (int)((double)value + 16384.0) - 16384;
    }

    public static int floorPositive(float value) {
        return (int)value;
    }

    public static int ceil(float value) {
        return 16384 - (int)(16384.0 - (double)value);
    }

    public static int ceilPositive(float value) {
        return (int)((double)value + 0.9999999);
    }

    public static int round(float value) {
        return (int)((double)value + 16384.5) - 16384;
    }

    public static int roundPositive(float value) {
        return (int)(value + 0.5f);
    }

    public static boolean isZero(float value) {
        return Math.abs(value) <= 1.0E-6f;
    }

    public static boolean isZero(float value, float tolerance) {
        return Math.abs(value) <= tolerance;
    }

    public static boolean isEqual(float a2, float b2) {
        return Math.abs(a2 - b2) <= 1.0E-6f;
    }

    public static boolean isEqual(float a2, float b2, float tolerance) {
        return Math.abs(a2 - b2) <= tolerance;
    }

    public static float log(float a2, float value) {
        return (float)(Math.log(value) / Math.log(a2));
    }

    public static float log2(float value) {
        return MathUtils.log(2.0f, value);
    }

    private static class Sin {
        static final float[] table = new float[16384];

        private Sin() {
        }

        static {
            for (int i2 = 0; i2 < 16384; ++i2) {
                Sin.table[i2] = (float)Math.sin(((float)i2 + 0.5f) / 16384.0f * ((float)Math.PI * 2));
            }
            Sin.table[0] = 0.0f;
            Sin.table[4096] = 1.0f;
            Sin.table[8192] = 0.0f;
            Sin.table[12288] = -1.0f;
        }
    }
}

