/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Vector2;

public final class GeometryUtils {
    private static final Vector2 tmp1 = new Vector2();
    private static final Vector2 tmp2 = new Vector2();
    private static final Vector2 tmp3 = new Vector2();

    private GeometryUtils() {
    }

    public static Vector2 toBarycoord(Vector2 p2, Vector2 a2, Vector2 b2, Vector2 c2, Vector2 barycentricOut) {
        Vector2 v0 = tmp1.set(b2).sub(a2);
        Vector2 v1 = tmp2.set(c2).sub(a2);
        Vector2 v2 = tmp3.set(p2).sub(a2);
        float d00 = v0.dot(v0);
        float d01 = v0.dot(v1);
        float d11 = v1.dot(v1);
        float d20 = v2.dot(v0);
        float d21 = v2.dot(v1);
        float denom = d00 * d11 - d01 * d01;
        barycentricOut.x = (d11 * d20 - d01 * d21) / denom;
        barycentricOut.y = (d00 * d21 - d01 * d20) / denom;
        return barycentricOut;
    }

    public static boolean barycoordInsideTriangle(Vector2 barycentric) {
        return barycentric.x >= 0.0f && barycentric.y >= 0.0f && barycentric.x + barycentric.y <= 1.0f;
    }

    public static Vector2 fromBarycoord(Vector2 barycentric, Vector2 a2, Vector2 b2, Vector2 c2, Vector2 interpolatedOut) {
        float u2 = 1.0f - barycentric.x - barycentric.y;
        interpolatedOut.x = u2 * a2.x + barycentric.x * b2.x + barycentric.y * c2.x;
        interpolatedOut.y = u2 * a2.y + barycentric.x * b2.y + barycentric.y * c2.y;
        return interpolatedOut;
    }

    public static float fromBarycoord(Vector2 barycentric, float a2, float b2, float c2) {
        float u2 = 1.0f - barycentric.x - barycentric.y;
        return u2 * a2 + barycentric.x * b2 + barycentric.y * c2;
    }

    public static float lowestPositiveRoot(float a2, float b2, float c2) {
        float r2;
        float invA;
        float det = b2 * b2 - 4.0f * a2 * c2;
        if (det < 0.0f) {
            return Float.NaN;
        }
        float sqrtD = (float)Math.sqrt(det);
        float r1 = (-b2 - sqrtD) * (invA = 1.0f / (2.0f * a2));
        if (r1 > (r2 = (-b2 + sqrtD) * invA)) {
            float tmp = r2;
            r2 = r1;
            r1 = tmp;
        }
        if (r1 > 0.0f) {
            return r1;
        }
        if (r2 > 0.0f) {
            return r2;
        }
        return Float.NaN;
    }

    public static boolean colinear(float x1, float y1, float x2, float y2, float x3, float y3) {
        float dx32 = x3 - x2;
        float dy21 = y2 - y1;
        float dx21 = x2 - x1;
        float dy32 = y3 - y2;
        float det = dx32 * dy21 - dx21 * dy32;
        return Math.abs(det) < 1.0E-6f;
    }

    public static Vector2 triangleCentroid(float x1, float y1, float x2, float y2, float x3, float y3, Vector2 centroid) {
        centroid.x = (x1 + x2 + x3) / 3.0f;
        centroid.y = (y1 + y2 + y3) / 3.0f;
        return centroid;
    }

    public static Vector2 triangleCircumcenter(float x1, float y1, float x2, float y2, float x3, float y3, Vector2 circumcenter) {
        float dx21 = x2 - x1;
        float dy21 = y2 - y1;
        float dx32 = x3 - x2;
        float dy32 = y3 - y2;
        float dx13 = x1 - x3;
        float dy13 = y1 - y3;
        float det = dx32 * dy21 - dx21 * dy32;
        if (Math.abs(det) < 1.0E-6f) {
            throw new IllegalArgumentException("Triangle points must not be colinear.");
        }
        float sqr1 = x1 * x1 + y1 * y1;
        float sqr2 = x2 * x2 + y2 * y2;
        float sqr3 = x3 * x3 + y3 * y3;
        circumcenter.set((sqr1 * dy32 + sqr2 * dy13 + sqr3 * dy21) / (det *= 2.0f), -(sqr1 * dx32 + sqr2 * dx13 + sqr3 * dx21) / det);
        return circumcenter;
    }

    public static float triangleCircumradius(float x1, float y1, float x2, float y2, float x3, float y3) {
        float y4;
        float x4;
        if (Math.abs(y2 - y1) < 1.0E-6f) {
            float m2 = -(x3 - x2) / (y3 - y2);
            float mx2 = (x2 + x3) / 2.0f;
            float my2 = (y2 + y3) / 2.0f;
            x4 = (x2 + x1) / 2.0f;
            y4 = m2 * (x4 - mx2) + my2;
        } else if (Math.abs(y3 - y2) < 1.0E-6f) {
            float m1 = -(x2 - x1) / (y2 - y1);
            float mx1 = (x1 + x2) / 2.0f;
            float my1 = (y1 + y2) / 2.0f;
            x4 = (x3 + x2) / 2.0f;
            y4 = m1 * (x4 - mx1) + my1;
        } else {
            float m1 = -(x2 - x1) / (y2 - y1);
            float m2 = -(x3 - x2) / (y3 - y2);
            float mx1 = (x1 + x2) / 2.0f;
            float mx2 = (x2 + x3) / 2.0f;
            float my1 = (y1 + y2) / 2.0f;
            float my2 = (y2 + y3) / 2.0f;
            x4 = (m1 * mx1 - m2 * mx2 + my2 - my1) / (m1 - m2);
            y4 = m1 * (x4 - mx1) + my1;
        }
        float dx = x1 - x4;
        float dy = y1 - y4;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public static float triangleQuality(float x1, float y1, float x2, float y2, float x3, float y3) {
        float sqLength1 = x1 * x1 + y1 * y1;
        float sqLength2 = x2 * x2 + y2 * y2;
        float sqLength3 = x3 * x3 + y3 * y3;
        return (float)Math.sqrt(Math.min(sqLength1, Math.min(sqLength2, sqLength3))) / GeometryUtils.triangleCircumradius(x1, y1, x2, y2, x3, y3);
    }

    public static float triangleArea(float x1, float y1, float x2, float y2, float x3, float y3) {
        return Math.abs((x1 - x3) * (y2 - y1) - (x1 - x2) * (y3 - y1)) * 0.5f;
    }

    public static Vector2 quadrilateralCentroid(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, Vector2 centroid) {
        float avgX1 = (x1 + x2 + x3) / 3.0f;
        float avgY1 = (y1 + y2 + y3) / 3.0f;
        float avgX2 = (x1 + x4 + x3) / 3.0f;
        float avgY2 = (y1 + y4 + y3) / 3.0f;
        centroid.x = avgX1 - (avgX1 - avgX2) / 2.0f;
        centroid.y = avgY1 - (avgY1 - avgY2) / 2.0f;
        return centroid;
    }

    public static Vector2 polygonCentroid(float[] polygon, int offset, int count, Vector2 centroid) {
        if (count < 6) {
            throw new IllegalArgumentException("A polygon must have 3 or more coordinate pairs.");
        }
        float area = 0.0f;
        float x2 = 0.0f;
        float y2 = 0.0f;
        int last = offset + count - 2;
        float x1 = polygon[last];
        float y1 = polygon[last + 1];
        for (int i2 = offset; i2 <= last; i2 += 2) {
            float x22 = polygon[i2];
            float y22 = polygon[i2 + 1];
            float a2 = x1 * y22 - x22 * y1;
            area += a2;
            x2 += (x1 + x22) * a2;
            y2 += (y1 + y22) * a2;
            x1 = x22;
            y1 = y22;
        }
        if (area == 0.0f) {
            centroid.x = 0.0f;
            centroid.y = 0.0f;
        } else {
            centroid.x = x2 / (6.0f * (area *= 0.5f));
            centroid.y = y2 / (6.0f * area);
        }
        return centroid;
    }

    public static float polygonArea(float[] polygon, int offset, int count) {
        float area = 0.0f;
        int last = offset + count - 2;
        float x1 = polygon[last];
        float y1 = polygon[last + 1];
        for (int i2 = offset; i2 <= last; i2 += 2) {
            float x2 = polygon[i2];
            float y2 = polygon[i2 + 1];
            area += x1 * y2 - x2 * y1;
            x1 = x2;
            y1 = y2;
        }
        return area * 0.5f;
    }

    public static void ensureCCW(float[] polygon) {
        GeometryUtils.ensureCCW(polygon, 0, polygon.length);
    }

    public static void ensureCCW(float[] polygon, int offset, int count) {
        if (!GeometryUtils.isClockwise(polygon, offset, count)) {
            return;
        }
        GeometryUtils.reverseVertices(polygon, offset, count);
    }

    public static void ensureClockwise(float[] polygon) {
        GeometryUtils.ensureClockwise(polygon, 0, polygon.length);
    }

    public static void ensureClockwise(float[] polygon, int offset, int count) {
        if (GeometryUtils.isClockwise(polygon, offset, count)) {
            return;
        }
        GeometryUtils.reverseVertices(polygon, offset, count);
    }

    public static void reverseVertices(float[] polygon, int offset, int count) {
        int lastX = offset + count - 2;
        int n2 = offset + count / 2;
        for (int i2 = offset; i2 < n2; i2 += 2) {
            int other = lastX - i2;
            float x2 = polygon[i2];
            float y2 = polygon[i2 + 1];
            polygon[i2] = polygon[other];
            polygon[i2 + 1] = polygon[other + 1];
            polygon[other] = x2;
            polygon[other + 1] = y2;
        }
    }

    public static boolean isClockwise(float[] polygon, int offset, int count) {
        if (count <= 2) {
            return false;
        }
        float area = 0.0f;
        int last = offset + count - 2;
        float x1 = polygon[last];
        float y1 = polygon[last + 1];
        for (int i2 = offset; i2 <= last; i2 += 2) {
            float x2 = polygon[i2];
            float y2 = polygon[i2 + 1];
            area += x1 * y2 - x2 * y1;
            x1 = x2;
            y1 = y2;
        }
        return area < 0.0f;
    }

    public static boolean isCCW(float[] polygon, int offset, int count) {
        return !GeometryUtils.isClockwise(polygon, offset, count);
    }
}

