/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Shape2D;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.NumberUtils;
import java.io.Serializable;

public class Circle
implements Serializable,
Shape2D {
    public float x;
    public float y;
    public float radius;

    public Circle() {
    }

    public Circle(float x2, float y2, float radius) {
        this.x = x2;
        this.y = y2;
        this.radius = radius;
    }

    public Circle(Vector2 position, float radius) {
        this.x = position.x;
        this.y = position.y;
        this.radius = radius;
    }

    public Circle(Circle circle) {
        this.x = circle.x;
        this.y = circle.y;
        this.radius = circle.radius;
    }

    public Circle(Vector2 center, Vector2 edge) {
        this.x = center.x;
        this.y = center.y;
        this.radius = Vector2.len(center.x - edge.x, center.y - edge.y);
    }

    public void set(float x2, float y2, float radius) {
        this.x = x2;
        this.y = y2;
        this.radius = radius;
    }

    public void set(Vector2 position, float radius) {
        this.x = position.x;
        this.y = position.y;
        this.radius = radius;
    }

    public void set(Circle circle) {
        this.x = circle.x;
        this.y = circle.y;
        this.radius = circle.radius;
    }

    public void set(Vector2 center, Vector2 edge) {
        this.x = center.x;
        this.y = center.y;
        this.radius = Vector2.len(center.x - edge.x, center.y - edge.y);
    }

    public void setPosition(Vector2 position) {
        this.x = position.x;
        this.y = position.y;
    }

    public void setPosition(float x2, float y2) {
        this.x = x2;
        this.y = y2;
    }

    public void setX(float x2) {
        this.x = x2;
    }

    public void setY(float y2) {
        this.y = y2;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    @Override
    public boolean contains(float x2, float y2) {
        return (x2 = this.x - x2) * x2 + (y2 = this.y - y2) * y2 <= this.radius * this.radius;
    }

    @Override
    public boolean contains(Vector2 point) {
        float dx = this.x - point.x;
        float dy = this.y - point.y;
        return dx * dx + dy * dy <= this.radius * this.radius;
    }

    public boolean contains(Circle c2) {
        float radiusDiff = this.radius - c2.radius;
        if (radiusDiff < 0.0f) {
            return false;
        }
        float dx = this.x - c2.x;
        float dy = this.y - c2.y;
        float dst = dx * dx + dy * dy;
        float radiusSum = this.radius + c2.radius;
        return !(radiusDiff * radiusDiff < dst) && dst < radiusSum * radiusSum;
    }

    public boolean overlaps(Circle c2) {
        float dx = this.x - c2.x;
        float dy = this.y - c2.y;
        float distance = dx * dx + dy * dy;
        float radiusSum = this.radius + c2.radius;
        return distance < radiusSum * radiusSum;
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.radius;
    }

    public float circumference() {
        return this.radius * ((float)Math.PI * 2);
    }

    public float area() {
        return this.radius * this.radius * (float)Math.PI;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 == null || o2.getClass() != this.getClass()) {
            return false;
        }
        Circle c2 = (Circle)o2;
        return this.x == c2.x && this.y == c2.y && this.radius == c2.radius;
    }

    public int hashCode() {
        int prime = 41;
        int result = 1;
        result = 41 * result + NumberUtils.floatToRawIntBits(this.radius);
        result = 41 * result + NumberUtils.floatToRawIntBits(this.x);
        result = 41 * result + NumberUtils.floatToRawIntBits(this.y);
        return result;
    }
}

