/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.glutils.HdpiMode;

public class HdpiUtils {
    private static HdpiMode mode = HdpiMode.Logical;

    public static void setMode(HdpiMode mode) {
        HdpiUtils.mode = mode;
    }

    public static void glScissor(int x2, int y2, int width, int height) {
        if (mode == HdpiMode.Logical && (Gdx.graphics.getWidth() != Gdx.graphics.getBackBufferWidth() || Gdx.graphics.getHeight() != Gdx.graphics.getBackBufferHeight())) {
            Gdx.gl.glScissor(HdpiUtils.toBackBufferX(x2), HdpiUtils.toBackBufferY(y2), HdpiUtils.toBackBufferX(width), HdpiUtils.toBackBufferY(height));
        } else {
            Gdx.gl.glScissor(x2, y2, width, height);
        }
    }

    public static void glViewport(int x2, int y2, int width, int height) {
        if (mode == HdpiMode.Logical && (Gdx.graphics.getWidth() != Gdx.graphics.getBackBufferWidth() || Gdx.graphics.getHeight() != Gdx.graphics.getBackBufferHeight())) {
            Gdx.gl.glViewport(HdpiUtils.toBackBufferX(x2), HdpiUtils.toBackBufferY(y2), HdpiUtils.toBackBufferX(width), HdpiUtils.toBackBufferY(height));
        } else {
            Gdx.gl.glViewport(x2, y2, width, height);
        }
    }

    public static int toLogicalX(int backBufferX) {
        return (int)((float)(backBufferX * Gdx.graphics.getWidth()) / (float)Gdx.graphics.getBackBufferWidth());
    }

    public static int toLogicalY(int backBufferY) {
        return (int)((float)(backBufferY * Gdx.graphics.getHeight()) / (float)Gdx.graphics.getBackBufferHeight());
    }

    public static int toBackBufferX(int logicalX) {
        return (int)((float)(logicalX * Gdx.graphics.getBackBufferWidth()) / (float)Gdx.graphics.getWidth());
    }

    public static int toBackBufferY(int logicalY) {
        return (int)((float)(logicalY * Gdx.graphics.getBackBufferHeight()) / (float)Gdx.graphics.getHeight());
    }
}

