/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureArrayData;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class FileTextureArrayData
implements TextureArrayData {
    private TextureData[] textureDatas;
    private boolean prepared;
    private Pixmap.Format format;
    private int depth;
    boolean useMipMaps;

    public FileTextureArrayData(Pixmap.Format format, boolean useMipMaps, FileHandle[] files) {
        this.format = format;
        this.useMipMaps = useMipMaps;
        this.depth = files.length;
        this.textureDatas = new TextureData[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            this.textureDatas[i2] = TextureData.Factory.loadFromFile(files[i2], format, useMipMaps);
        }
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public void prepare() {
        int width = -1;
        int height = -1;
        for (TextureData data : this.textureDatas) {
            data.prepare();
            if (width == -1) {
                width = data.getWidth();
                height = data.getHeight();
                continue;
            }
            if (width == data.getWidth() && height == data.getHeight()) continue;
            throw new GdxRuntimeException("Error whilst preparing TextureArray: TextureArray Textures must have equal dimensions.");
        }
        this.prepared = true;
    }

    @Override
    public void consumeTextureArrayData() {
        boolean containsCustomData = false;
        for (int i2 = 0; i2 < this.textureDatas.length; ++i2) {
            if (this.textureDatas[i2].getType() == TextureData.TextureDataType.Custom) {
                this.textureDatas[i2].consumeCustomData(35866);
                containsCustomData = true;
                continue;
            }
            TextureData texData = this.textureDatas[i2];
            Pixmap pixmap = texData.consumePixmap();
            boolean disposePixmap = texData.disposePixmap();
            if (texData.getFormat() != pixmap.getFormat()) {
                Pixmap temp = new Pixmap(pixmap.getWidth(), pixmap.getHeight(), texData.getFormat());
                temp.setBlending(Pixmap.Blending.None);
                temp.drawPixmap(pixmap, 0, 0, 0, 0, pixmap.getWidth(), pixmap.getHeight());
                if (texData.disposePixmap()) {
                    pixmap.dispose();
                }
                pixmap = temp;
                disposePixmap = true;
            }
            Gdx.gl30.glTexSubImage3D(35866, 0, 0, 0, i2, pixmap.getWidth(), pixmap.getHeight(), 1, pixmap.getGLInternalFormat(), pixmap.getGLType(), pixmap.getPixels());
            if (!disposePixmap) continue;
            pixmap.dispose();
        }
        if (this.useMipMaps && !containsCustomData) {
            Gdx.gl20.glGenerateMipmap(35866);
        }
    }

    @Override
    public int getWidth() {
        return this.textureDatas[0].getWidth();
    }

    @Override
    public int getHeight() {
        return this.textureDatas[0].getHeight();
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getInternalFormat() {
        return Pixmap.Format.toGlFormat(this.format);
    }

    @Override
    public int getGLType() {
        return Pixmap.Format.toGlType(this.format);
    }

    @Override
    public boolean isManaged() {
        for (TextureData data : this.textureDatas) {
            if (data.isManaged()) continue;
            return false;
        }
        return true;
    }
}

