/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.influencers;

import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.ParticleControllerComponent;
import com.badlogic.gdx.graphics.g3d.particles.influencers.SimpleInfluencer;

public class ScaleInfluencer
extends SimpleInfluencer {
    public ScaleInfluencer() {
        this.valueChannelDescriptor = ParticleChannels.Scale;
    }

    @Override
    public void activateParticles(int startIndex, int count) {
        if (this.value.isRelative()) {
            int i2 = startIndex * this.valueChannel.strideSize;
            int a2 = startIndex * this.interpolationChannel.strideSize;
            int c2 = i2 + count * this.valueChannel.strideSize;
            while (i2 < c2) {
                float start = this.value.newLowValue() * this.controller.scale.x;
                float diff = this.value.newHighValue() * this.controller.scale.x;
                this.interpolationChannel.data[a2 + 0] = start;
                this.interpolationChannel.data[a2 + 1] = diff;
                this.valueChannel.data[i2] = start + diff * this.value.getScale(0.0f);
                i2 += this.valueChannel.strideSize;
                a2 += this.interpolationChannel.strideSize;
            }
        } else {
            int i3 = startIndex * this.valueChannel.strideSize;
            int a3 = startIndex * this.interpolationChannel.strideSize;
            int c3 = i3 + count * this.valueChannel.strideSize;
            while (i3 < c3) {
                float start = this.value.newLowValue() * this.controller.scale.x;
                float diff = this.value.newHighValue() * this.controller.scale.x - start;
                this.interpolationChannel.data[a3 + 0] = start;
                this.interpolationChannel.data[a3 + 1] = diff;
                this.valueChannel.data[i3] = start + diff * this.value.getScale(0.0f);
                i3 += this.valueChannel.strideSize;
                a3 += this.interpolationChannel.strideSize;
            }
        }
    }

    public ScaleInfluencer(ScaleInfluencer scaleInfluencer) {
        super(scaleInfluencer);
    }

    @Override
    public ParticleControllerComponent copy() {
        return new ScaleInfluencer(this);
    }
}

