/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.influencers;

import com.badlogic.gdx.graphics.g3d.particles.ParallelArray;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.ParticleController;
import com.badlogic.gdx.graphics.g3d.particles.influencers.DynamicsModifier;
import com.badlogic.gdx.graphics.g3d.particles.influencers.Influencer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import java.util.Arrays;

public class DynamicsInfluencer
extends Influencer {
    public Array<DynamicsModifier> velocities;
    private ParallelArray.FloatChannel accellerationChannel;
    private ParallelArray.FloatChannel positionChannel;
    private ParallelArray.FloatChannel previousPositionChannel;
    private ParallelArray.FloatChannel rotationChannel;
    private ParallelArray.FloatChannel angularVelocityChannel;
    boolean hasAcceleration;
    boolean has2dAngularVelocity;
    boolean has3dAngularVelocity;

    public DynamicsInfluencer() {
        this.velocities = new Array(true, 3, DynamicsModifier.class);
    }

    public DynamicsInfluencer(DynamicsModifier ... velocities) {
        this.velocities = new Array(true, velocities.length, DynamicsModifier.class);
        for (DynamicsModifier value : velocities) {
            this.velocities.add((DynamicsModifier)value.copy());
        }
    }

    public DynamicsInfluencer(DynamicsInfluencer velocityInfluencer) {
        this(velocityInfluencer.velocities.toArray(DynamicsModifier.class));
    }

    @Override
    public void allocateChannels() {
        for (int k2 = 0; k2 < this.velocities.size; ++k2) {
            ((DynamicsModifier[])this.velocities.items)[k2].allocateChannels();
        }
        this.accellerationChannel = (ParallelArray.FloatChannel)this.controller.particles.getChannel(ParticleChannels.Acceleration);
        boolean bl2 = this.hasAcceleration = this.accellerationChannel != null;
        if (this.hasAcceleration) {
            this.positionChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Position);
            this.previousPositionChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.PreviousPosition);
        }
        this.angularVelocityChannel = (ParallelArray.FloatChannel)this.controller.particles.getChannel(ParticleChannels.AngularVelocity2D);
        boolean bl3 = this.has2dAngularVelocity = this.angularVelocityChannel != null;
        if (this.has2dAngularVelocity) {
            this.rotationChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Rotation2D);
            this.has3dAngularVelocity = false;
        } else {
            this.angularVelocityChannel = (ParallelArray.FloatChannel)this.controller.particles.getChannel(ParticleChannels.AngularVelocity3D);
            boolean bl4 = this.has3dAngularVelocity = this.angularVelocityChannel != null;
            if (this.has3dAngularVelocity) {
                this.rotationChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Rotation3D);
            }
        }
    }

    @Override
    public void set(ParticleController particleController) {
        super.set(particleController);
        for (int k2 = 0; k2 < this.velocities.size; ++k2) {
            ((DynamicsModifier[])this.velocities.items)[k2].set(particleController);
        }
    }

    @Override
    public void init() {
        for (int k2 = 0; k2 < this.velocities.size; ++k2) {
            ((DynamicsModifier[])this.velocities.items)[k2].init();
        }
    }

    @Override
    public void activateParticles(int startIndex, int count) {
        int c2;
        int i2;
        if (this.hasAcceleration) {
            c2 = i2 + count * this.positionChannel.strideSize;
            for (i2 = startIndex * this.positionChannel.strideSize; i2 < c2; i2 += this.positionChannel.strideSize) {
                this.previousPositionChannel.data[i2 + 0] = this.positionChannel.data[i2 + 0];
                this.previousPositionChannel.data[i2 + 1] = this.positionChannel.data[i2 + 1];
                this.previousPositionChannel.data[i2 + 2] = this.positionChannel.data[i2 + 2];
            }
        }
        if (this.has2dAngularVelocity) {
            c2 = i2 + count * this.rotationChannel.strideSize;
            for (i2 = startIndex * this.rotationChannel.strideSize; i2 < c2; i2 += this.rotationChannel.strideSize) {
                this.rotationChannel.data[i2 + 0] = 1.0f;
                this.rotationChannel.data[i2 + 1] = 0.0f;
            }
        } else if (this.has3dAngularVelocity) {
            c2 = i2 + count * this.rotationChannel.strideSize;
            for (i2 = startIndex * this.rotationChannel.strideSize; i2 < c2; i2 += this.rotationChannel.strideSize) {
                this.rotationChannel.data[i2 + 0] = 0.0f;
                this.rotationChannel.data[i2 + 1] = 0.0f;
                this.rotationChannel.data[i2 + 2] = 0.0f;
                this.rotationChannel.data[i2 + 3] = 1.0f;
            }
        }
        for (int k2 = 0; k2 < this.velocities.size; ++k2) {
            ((DynamicsModifier[])this.velocities.items)[k2].activateParticles(startIndex, count);
        }
    }

    @Override
    public void update() {
        block9: {
            int offset;
            int i2;
            block8: {
                if (this.hasAcceleration) {
                    Arrays.fill(this.accellerationChannel.data, 0, this.controller.particles.size * this.accellerationChannel.strideSize, 0.0f);
                }
                if (this.has2dAngularVelocity || this.has3dAngularVelocity) {
                    Arrays.fill(this.angularVelocityChannel.data, 0, this.controller.particles.size * this.angularVelocityChannel.strideSize, 0.0f);
                }
                for (int k2 = 0; k2 < this.velocities.size; ++k2) {
                    ((DynamicsModifier[])this.velocities.items)[k2].update();
                }
                if (this.hasAcceleration) {
                    i2 = 0;
                    offset = 0;
                    while (i2 < this.controller.particles.size) {
                        float x2 = this.positionChannel.data[offset + 0];
                        float y2 = this.positionChannel.data[offset + 1];
                        float z2 = this.positionChannel.data[offset + 2];
                        this.positionChannel.data[offset + 0] = 2.0f * x2 - this.previousPositionChannel.data[offset + 0] + this.accellerationChannel.data[offset + 0] * this.controller.deltaTimeSqr;
                        this.positionChannel.data[offset + 1] = 2.0f * y2 - this.previousPositionChannel.data[offset + 1] + this.accellerationChannel.data[offset + 1] * this.controller.deltaTimeSqr;
                        this.positionChannel.data[offset + 2] = 2.0f * z2 - this.previousPositionChannel.data[offset + 2] + this.accellerationChannel.data[offset + 2] * this.controller.deltaTimeSqr;
                        this.previousPositionChannel.data[offset + 0] = x2;
                        this.previousPositionChannel.data[offset + 1] = y2;
                        this.previousPositionChannel.data[offset + 2] = z2;
                        ++i2;
                        offset += this.positionChannel.strideSize;
                    }
                }
                if (!this.has2dAngularVelocity) break block8;
                i2 = 0;
                offset = 0;
                while (i2 < this.controller.particles.size) {
                    float rotation = this.angularVelocityChannel.data[i2] * this.controller.deltaTime;
                    if (rotation != 0.0f) {
                        float cosBeta = MathUtils.cosDeg(rotation);
                        float sinBeta = MathUtils.sinDeg(rotation);
                        float currentCosine = this.rotationChannel.data[offset + 0];
                        float currentSine = this.rotationChannel.data[offset + 1];
                        float newCosine = currentCosine * cosBeta - currentSine * sinBeta;
                        float newSine = currentSine * cosBeta + currentCosine * sinBeta;
                        this.rotationChannel.data[offset + 0] = newCosine;
                        this.rotationChannel.data[offset + 1] = newSine;
                    }
                    ++i2;
                    offset += this.rotationChannel.strideSize;
                }
                break block9;
            }
            if (!this.has3dAngularVelocity) break block9;
            i2 = 0;
            offset = 0;
            int angularOffset = 0;
            while (i2 < this.controller.particles.size) {
                float wx = this.angularVelocityChannel.data[angularOffset + 0];
                float wy = this.angularVelocityChannel.data[angularOffset + 1];
                float wz = this.angularVelocityChannel.data[angularOffset + 2];
                float qx = this.rotationChannel.data[offset + 0];
                float qy = this.rotationChannel.data[offset + 1];
                float qz = this.rotationChannel.data[offset + 2];
                float qw = this.rotationChannel.data[offset + 3];
                TMP_Q.set(wx, wy, wz, 0.0f).mul(qx, qy, qz, qw).mul(0.5f * this.controller.deltaTime).add(qx, qy, qz, qw).nor();
                this.rotationChannel.data[offset + 0] = DynamicsInfluencer.TMP_Q.x;
                this.rotationChannel.data[offset + 1] = DynamicsInfluencer.TMP_Q.y;
                this.rotationChannel.data[offset + 2] = DynamicsInfluencer.TMP_Q.z;
                this.rotationChannel.data[offset + 3] = DynamicsInfluencer.TMP_Q.w;
                ++i2;
                offset += this.rotationChannel.strideSize;
                angularOffset += this.angularVelocityChannel.strideSize;
            }
        }
    }

    @Override
    public DynamicsInfluencer copy() {
        return new DynamicsInfluencer(this);
    }

    @Override
    public void write(Json json) {
        json.writeValue("velocities", this.velocities, Array.class, DynamicsModifier.class);
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.velocities.addAll(json.readValue("velocities", Array.class, DynamicsModifier.class, jsonData));
    }
}

