/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.g2d.TextureRegion;

public class PolygonRegion {
    final float[] textureCoords;
    final float[] vertices;
    final short[] triangles;
    final TextureRegion region;

    public PolygonRegion(TextureRegion region, float[] vertices, short[] triangles) {
        this.region = region;
        this.vertices = vertices;
        this.triangles = triangles;
        this.textureCoords = new float[vertices.length];
        float[] textureCoords = this.textureCoords;
        float u2 = region.u;
        float v2 = region.v;
        float uvWidth = region.u2 - u2;
        float uvHeight = region.v2 - v2;
        int width = region.regionWidth;
        int height = region.regionHeight;
        int n2 = vertices.length;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            textureCoords[i2] = u2 + uvWidth * (vertices[i2] / (float)width);
            textureCoords[i2 + 1] = v2 + uvHeight * (1.0f - vertices[i2 + 1] / (float)height);
        }
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public short[] getTriangles() {
        return this.triangles;
    }

    public float[] getTextureCoords() {
        return this.textureCoords;
    }

    public TextureRegion getRegion() {
        return this.region;
    }
}

