/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;

public class ParticleEffectPool
extends Pool<PooledEffect> {
    private final ParticleEffect effect;

    public ParticleEffectPool(ParticleEffect effect, int initialCapacity, int max) {
        super(initialCapacity, max);
        this.effect = effect;
    }

    @Override
    protected PooledEffect newObject() {
        PooledEffect pooledEffect = new PooledEffect(this.effect);
        pooledEffect.start();
        return pooledEffect;
    }

    @Override
    public void free(PooledEffect effect) {
        super.free(effect);
        effect.reset(false);
        if (effect.xSizeScale != this.effect.xSizeScale || effect.ySizeScale != this.effect.ySizeScale || effect.motionScale != this.effect.motionScale) {
            Array<ParticleEmitter> emitters = effect.getEmitters();
            Array<ParticleEmitter> templateEmitters = this.effect.getEmitters();
            for (int i2 = 0; i2 < emitters.size; ++i2) {
                ParticleEmitter emitter = emitters.get(i2);
                ParticleEmitter templateEmitter = templateEmitters.get(i2);
                emitter.matchSize(templateEmitter);
                emitter.matchMotion(templateEmitter);
            }
            effect.xSizeScale = this.effect.xSizeScale;
            effect.ySizeScale = this.effect.ySizeScale;
            effect.motionScale = this.effect.motionScale;
        }
    }

    public class PooledEffect
    extends ParticleEffect {
        PooledEffect(ParticleEffect effect) {
            super(effect);
        }

        public void free() {
            ParticleEffectPool.this.free(this);
        }
    }
}

