/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class CpuSpriteBatch
extends SpriteBatch {
    private final Matrix4 virtualMatrix = new Matrix4();
    private final Affine2 adjustAffine = new Affine2();
    private boolean adjustNeeded;
    private boolean haveIdentityRealMatrix = true;
    private final Affine2 tmpAffine = new Affine2();

    public CpuSpriteBatch() {
        this(1000);
    }

    public CpuSpriteBatch(int size) {
        this(size, null);
    }

    public CpuSpriteBatch(int size, ShaderProgram defaultShader) {
        super(size, defaultShader);
    }

    public void flushAndSyncTransformMatrix() {
        this.flush();
        if (this.adjustNeeded) {
            this.haveIdentityRealMatrix = CpuSpriteBatch.checkIdt(this.virtualMatrix);
            if (!this.haveIdentityRealMatrix && this.virtualMatrix.det() == 0.0f) {
                throw new GdxRuntimeException("Transform matrix is singular, can't sync");
            }
            this.adjustNeeded = false;
            super.setTransformMatrix(this.virtualMatrix);
        }
    }

    @Override
    public Matrix4 getTransformMatrix() {
        return this.adjustNeeded ? this.virtualMatrix : super.getTransformMatrix();
    }

    @Override
    public void setTransformMatrix(Matrix4 transform) {
        Matrix4 realMatrix = super.getTransformMatrix();
        if (CpuSpriteBatch.checkEqual(realMatrix, transform)) {
            this.adjustNeeded = false;
        } else if (this.isDrawing()) {
            this.virtualMatrix.setAsAffine(transform);
            this.adjustNeeded = true;
            if (this.haveIdentityRealMatrix) {
                this.adjustAffine.set(transform);
            } else {
                this.tmpAffine.set(transform);
                this.adjustAffine.set(realMatrix).inv().mul(this.tmpAffine);
            }
        } else {
            realMatrix.setAsAffine(transform);
            this.haveIdentityRealMatrix = CpuSpriteBatch.checkIdt(realMatrix);
        }
    }

    public void setTransformMatrix(Affine2 transform) {
        Matrix4 realMatrix = super.getTransformMatrix();
        if (CpuSpriteBatch.checkEqual(realMatrix, transform)) {
            this.adjustNeeded = false;
        } else {
            this.virtualMatrix.setAsAffine(transform);
            if (this.isDrawing()) {
                this.adjustNeeded = true;
                if (this.haveIdentityRealMatrix) {
                    this.adjustAffine.set(transform);
                } else {
                    this.adjustAffine.set(realMatrix).inv().mul(transform);
                }
            } else {
                realMatrix.setAsAffine(transform);
                this.haveIdentityRealMatrix = CpuSpriteBatch.checkIdt(realMatrix);
            }
        }
    }

    @Override
    public void draw(Texture texture, float x2, float y2, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation, int srcX, int srcY, int srcWidth, int srcHeight, boolean flipX, boolean flipY) {
        if (!this.adjustNeeded) {
            super.draw(texture, x2, y2, originX, originY, width, height, scaleX, scaleY, rotation, srcX, srcY, srcWidth, srcHeight, flipX, flipY);
        } else {
            this.drawAdjusted(texture, x2, y2, originX, originY, width, height, scaleX, scaleY, rotation, srcX, srcY, srcWidth, srcHeight, flipX, flipY);
        }
    }

    @Override
    public void draw(Texture texture, float x2, float y2, float width, float height, int srcX, int srcY, int srcWidth, int srcHeight, boolean flipX, boolean flipY) {
        if (!this.adjustNeeded) {
            super.draw(texture, x2, y2, width, height, srcX, srcY, srcWidth, srcHeight, flipX, flipY);
        } else {
            this.drawAdjusted(texture, x2, y2, 0.0f, 0.0f, width, height, 1.0f, 1.0f, 0.0f, srcX, srcY, srcWidth, srcHeight, flipX, flipY);
        }
    }

    @Override
    public void draw(Texture texture, float x2, float y2, int srcX, int srcY, int srcWidth, int srcHeight) {
        if (!this.adjustNeeded) {
            super.draw(texture, x2, y2, srcX, srcY, srcWidth, srcHeight);
        } else {
            this.drawAdjusted(texture, x2, y2, 0.0f, 0.0f, srcWidth, srcHeight, 1.0f, 1.0f, 0.0f, srcX, srcY, srcWidth, srcHeight, false, false);
        }
    }

    @Override
    public void draw(Texture texture, float x2, float y2, float width, float height, float u2, float v2, float u22, float v22) {
        if (!this.adjustNeeded) {
            super.draw(texture, x2, y2, width, height, u2, v2, u22, v22);
        } else {
            this.drawAdjustedUV(texture, x2, y2, 0.0f, 0.0f, width, height, 1.0f, 1.0f, 0.0f, u2, v2, u22, v22, false, false);
        }
    }

    @Override
    public void draw(Texture texture, float x2, float y2) {
        if (!this.adjustNeeded) {
            super.draw(texture, x2, y2);
        } else {
            this.drawAdjusted(texture, x2, y2, 0.0f, 0.0f, texture.getWidth(), texture.getHeight(), 1.0f, 1.0f, 0.0f, 0, 1, 1, 0, false, false);
        }
    }

    @Override
    public void draw(Texture texture, float x2, float y2, float width, float height) {
        if (!this.adjustNeeded) {
            super.draw(texture, x2, y2, width, height);
        } else {
            this.drawAdjusted(texture, x2, y2, 0.0f, 0.0f, width, height, 1.0f, 1.0f, 0.0f, 0, 1, 1, 0, false, false);
        }
    }

    @Override
    public void draw(TextureRegion region, float x2, float y2) {
        if (!this.adjustNeeded) {
            super.draw(region, x2, y2);
        } else {
            this.drawAdjusted(region, x2, y2, 0.0f, 0.0f, region.getRegionWidth(), region.getRegionHeight(), 1.0f, 1.0f, 0.0f);
        }
    }

    @Override
    public void draw(TextureRegion region, float x2, float y2, float width, float height) {
        if (!this.adjustNeeded) {
            super.draw(region, x2, y2, width, height);
        } else {
            this.drawAdjusted(region, x2, y2, 0.0f, 0.0f, width, height, 1.0f, 1.0f, 0.0f);
        }
    }

    @Override
    public void draw(TextureRegion region, float x2, float y2, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        if (!this.adjustNeeded) {
            super.draw(region, x2, y2, originX, originY, width, height, scaleX, scaleY, rotation);
        } else {
            this.drawAdjusted(region, x2, y2, originX, originY, width, height, scaleX, scaleY, rotation);
        }
    }

    @Override
    public void draw(TextureRegion region, float x2, float y2, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation, boolean clockwise) {
        if (!this.adjustNeeded) {
            super.draw(region, x2, y2, originX, originY, width, height, scaleX, scaleY, rotation, clockwise);
        } else {
            this.drawAdjusted(region, x2, y2, originX, originY, width, height, scaleX, scaleY, rotation, clockwise);
        }
    }

    @Override
    public void draw(Texture texture, float[] spriteVertices, int offset, int count) {
        if (count % 20 != 0) {
            throw new GdxRuntimeException("invalid vertex count");
        }
        if (!this.adjustNeeded) {
            super.draw(texture, spriteVertices, offset, count);
        } else {
            this.drawAdjusted(texture, spriteVertices, offset, count);
        }
    }

    @Override
    public void draw(TextureRegion region, float width, float height, Affine2 transform) {
        if (!this.adjustNeeded) {
            super.draw(region, width, height, transform);
        } else {
            this.drawAdjusted(region, width, height, transform);
        }
    }

    private void drawAdjusted(TextureRegion region, float x2, float y2, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        this.drawAdjustedUV(region.texture, x2, y2, originX, originY, width, height, scaleX, scaleY, rotation, region.u, region.v2, region.u2, region.v, false, false);
    }

    private void drawAdjusted(Texture texture, float x2, float y2, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation, int srcX, int srcY, int srcWidth, int srcHeight, boolean flipX, boolean flipY) {
        float invTexWidth = 1.0f / (float)texture.getWidth();
        float invTexHeight = 1.0f / (float)texture.getHeight();
        float u2 = (float)srcX * invTexWidth;
        float v2 = (float)(srcY + srcHeight) * invTexHeight;
        float u22 = (float)(srcX + srcWidth) * invTexWidth;
        float v22 = (float)srcY * invTexHeight;
        this.drawAdjustedUV(texture, x2, y2, originX, originY, width, height, scaleX, scaleY, rotation, u2, v2, u22, v22, flipX, flipY);
    }

    private void drawAdjustedUV(Texture texture, float x2, float y2, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation, float u2, float v2, float u22, float v22, boolean flipX, boolean flipY) {
        float tmp;
        float y4;
        float x4;
        float y3;
        float x3;
        float y22;
        float x22;
        float y1;
        float x1;
        if (!this.drawing) {
            throw new IllegalStateException("CpuSpriteBatch.begin must be called before draw.");
        }
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.idx == this.vertices.length) {
            super.flush();
        }
        float worldOriginX = x2 + originX;
        float worldOriginY = y2 + originY;
        float fx = -originX;
        float fy = -originY;
        float fx2 = width - originX;
        float fy2 = height - originY;
        if (scaleX != 1.0f || scaleY != 1.0f) {
            fx *= scaleX;
            fy *= scaleY;
            fx2 *= scaleX;
            fy2 *= scaleY;
        }
        float p1x = fx;
        float p1y = fy;
        float p2x = fx;
        float p2y = fy2;
        float p3x = fx2;
        float p3y = fy2;
        float p4x = fx2;
        float p4y = fy;
        if (rotation != 0.0f) {
            float cos = MathUtils.cosDeg(rotation);
            float sin = MathUtils.sinDeg(rotation);
            x1 = cos * p1x - sin * p1y;
            y1 = sin * p1x + cos * p1y;
            x22 = cos * p2x - sin * p2y;
            y22 = sin * p2x + cos * p2y;
            x3 = cos * p3x - sin * p3y;
            y3 = sin * p3x + cos * p3y;
            x4 = x1 + (x3 - x22);
            y4 = y3 - (y22 - y1);
        } else {
            x1 = p1x;
            y1 = p1y;
            x22 = p2x;
            y22 = p2y;
            x3 = p3x;
            y3 = p3y;
            x4 = p4x;
            y4 = p4y;
        }
        x1 += worldOriginX;
        y1 += worldOriginY;
        x22 += worldOriginX;
        y22 += worldOriginY;
        x3 += worldOriginX;
        y3 += worldOriginY;
        x4 += worldOriginX;
        y4 += worldOriginY;
        if (flipX) {
            tmp = u2;
            u2 = u22;
            u22 = tmp;
        }
        if (flipY) {
            tmp = v2;
            v2 = v22;
            v22 = tmp;
        }
        Affine2 t2 = this.adjustAffine;
        this.vertices[this.idx + 0] = t2.m00 * x1 + t2.m01 * y1 + t2.m02;
        this.vertices[this.idx + 1] = t2.m10 * x1 + t2.m11 * y1 + t2.m12;
        this.vertices[this.idx + 2] = this.colorPacked;
        this.vertices[this.idx + 3] = u2;
        this.vertices[this.idx + 4] = v2;
        this.vertices[this.idx + 5] = t2.m00 * x22 + t2.m01 * y22 + t2.m02;
        this.vertices[this.idx + 6] = t2.m10 * x22 + t2.m11 * y22 + t2.m12;
        this.vertices[this.idx + 7] = this.colorPacked;
        this.vertices[this.idx + 8] = u2;
        this.vertices[this.idx + 9] = v22;
        this.vertices[this.idx + 10] = t2.m00 * x3 + t2.m01 * y3 + t2.m02;
        this.vertices[this.idx + 11] = t2.m10 * x3 + t2.m11 * y3 + t2.m12;
        this.vertices[this.idx + 12] = this.colorPacked;
        this.vertices[this.idx + 13] = u22;
        this.vertices[this.idx + 14] = v22;
        this.vertices[this.idx + 15] = t2.m00 * x4 + t2.m01 * y4 + t2.m02;
        this.vertices[this.idx + 16] = t2.m10 * x4 + t2.m11 * y4 + t2.m12;
        this.vertices[this.idx + 17] = this.colorPacked;
        this.vertices[this.idx + 18] = u22;
        this.vertices[this.idx + 19] = v2;
        this.idx += 20;
    }

    private void drawAdjusted(TextureRegion region, float x2, float y2, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation, boolean clockwise) {
        float v4;
        float u4;
        float v3;
        float u3;
        float v2;
        float u2;
        float v1;
        float u1;
        float y4;
        float x4;
        float y3;
        float x3;
        float y22;
        float x22;
        float y1;
        float x1;
        if (!this.drawing) {
            throw new IllegalStateException("CpuSpriteBatch.begin must be called before draw.");
        }
        if (region.texture != this.lastTexture) {
            this.switchTexture(region.texture);
        } else if (this.idx == this.vertices.length) {
            super.flush();
        }
        float worldOriginX = x2 + originX;
        float worldOriginY = y2 + originY;
        float fx = -originX;
        float fy = -originY;
        float fx2 = width - originX;
        float fy2 = height - originY;
        if (scaleX != 1.0f || scaleY != 1.0f) {
            fx *= scaleX;
            fy *= scaleY;
            fx2 *= scaleX;
            fy2 *= scaleY;
        }
        float p1x = fx;
        float p1y = fy;
        float p2x = fx;
        float p2y = fy2;
        float p3x = fx2;
        float p3y = fy2;
        float p4x = fx2;
        float p4y = fy;
        if (rotation != 0.0f) {
            float cos = MathUtils.cosDeg(rotation);
            float sin = MathUtils.sinDeg(rotation);
            x1 = cos * p1x - sin * p1y;
            y1 = sin * p1x + cos * p1y;
            x22 = cos * p2x - sin * p2y;
            y22 = sin * p2x + cos * p2y;
            x3 = cos * p3x - sin * p3y;
            y3 = sin * p3x + cos * p3y;
            x4 = x1 + (x3 - x22);
            y4 = y3 - (y22 - y1);
        } else {
            x1 = p1x;
            y1 = p1y;
            x22 = p2x;
            y22 = p2y;
            x3 = p3x;
            y3 = p3y;
            x4 = p4x;
            y4 = p4y;
        }
        x1 += worldOriginX;
        y1 += worldOriginY;
        x22 += worldOriginX;
        y22 += worldOriginY;
        x3 += worldOriginX;
        y3 += worldOriginY;
        x4 += worldOriginX;
        y4 += worldOriginY;
        if (clockwise) {
            u1 = region.u2;
            v1 = region.v2;
            u2 = region.u;
            v2 = region.v2;
            u3 = region.u;
            v3 = region.v;
            u4 = region.u2;
            v4 = region.v;
        } else {
            u1 = region.u;
            v1 = region.v;
            u2 = region.u2;
            v2 = region.v;
            u3 = region.u2;
            v3 = region.v2;
            u4 = region.u;
            v4 = region.v2;
        }
        Affine2 t2 = this.adjustAffine;
        this.vertices[this.idx + 0] = t2.m00 * x1 + t2.m01 * y1 + t2.m02;
        this.vertices[this.idx + 1] = t2.m10 * x1 + t2.m11 * y1 + t2.m12;
        this.vertices[this.idx + 2] = this.colorPacked;
        this.vertices[this.idx + 3] = u1;
        this.vertices[this.idx + 4] = v1;
        this.vertices[this.idx + 5] = t2.m00 * x22 + t2.m01 * y22 + t2.m02;
        this.vertices[this.idx + 6] = t2.m10 * x22 + t2.m11 * y22 + t2.m12;
        this.vertices[this.idx + 7] = this.colorPacked;
        this.vertices[this.idx + 8] = u2;
        this.vertices[this.idx + 9] = v2;
        this.vertices[this.idx + 10] = t2.m00 * x3 + t2.m01 * y3 + t2.m02;
        this.vertices[this.idx + 11] = t2.m10 * x3 + t2.m11 * y3 + t2.m12;
        this.vertices[this.idx + 12] = this.colorPacked;
        this.vertices[this.idx + 13] = u3;
        this.vertices[this.idx + 14] = v3;
        this.vertices[this.idx + 15] = t2.m00 * x4 + t2.m01 * y4 + t2.m02;
        this.vertices[this.idx + 16] = t2.m10 * x4 + t2.m11 * y4 + t2.m12;
        this.vertices[this.idx + 17] = this.colorPacked;
        this.vertices[this.idx + 18] = u4;
        this.vertices[this.idx + 19] = v4;
        this.idx += 20;
    }

    private void drawAdjusted(TextureRegion region, float width, float height, Affine2 transform) {
        if (!this.drawing) {
            throw new IllegalStateException("CpuSpriteBatch.begin must be called before draw.");
        }
        if (region.texture != this.lastTexture) {
            this.switchTexture(region.texture);
        } else if (this.idx == this.vertices.length) {
            super.flush();
        }
        Affine2 t2 = transform;
        float x1 = t2.m02;
        float y1 = t2.m12;
        float x2 = t2.m01 * height + t2.m02;
        float y2 = t2.m11 * height + t2.m12;
        float x3 = t2.m00 * width + t2.m01 * height + t2.m02;
        float y3 = t2.m10 * width + t2.m11 * height + t2.m12;
        float x4 = t2.m00 * width + t2.m02;
        float y4 = t2.m10 * width + t2.m12;
        float u2 = region.u;
        float v2 = region.v2;
        float u22 = region.u2;
        float v22 = region.v;
        t2 = this.adjustAffine;
        this.vertices[this.idx + 0] = t2.m00 * x1 + t2.m01 * y1 + t2.m02;
        this.vertices[this.idx + 1] = t2.m10 * x1 + t2.m11 * y1 + t2.m12;
        this.vertices[this.idx + 2] = this.colorPacked;
        this.vertices[this.idx + 3] = u2;
        this.vertices[this.idx + 4] = v2;
        this.vertices[this.idx + 5] = t2.m00 * x2 + t2.m01 * y2 + t2.m02;
        this.vertices[this.idx + 6] = t2.m10 * x2 + t2.m11 * y2 + t2.m12;
        this.vertices[this.idx + 7] = this.colorPacked;
        this.vertices[this.idx + 8] = u2;
        this.vertices[this.idx + 9] = v22;
        this.vertices[this.idx + 10] = t2.m00 * x3 + t2.m01 * y3 + t2.m02;
        this.vertices[this.idx + 11] = t2.m10 * x3 + t2.m11 * y3 + t2.m12;
        this.vertices[this.idx + 12] = this.colorPacked;
        this.vertices[this.idx + 13] = u22;
        this.vertices[this.idx + 14] = v22;
        this.vertices[this.idx + 15] = t2.m00 * x4 + t2.m01 * y4 + t2.m02;
        this.vertices[this.idx + 16] = t2.m10 * x4 + t2.m11 * y4 + t2.m12;
        this.vertices[this.idx + 17] = this.colorPacked;
        this.vertices[this.idx + 18] = u22;
        this.vertices[this.idx + 19] = v2;
        this.idx += 20;
    }

    private void drawAdjusted(Texture texture, float[] spriteVertices, int offset, int count) {
        if (!this.drawing) {
            throw new IllegalStateException("CpuSpriteBatch.begin must be called before draw.");
        }
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        }
        Affine2 t2 = this.adjustAffine;
        int copyCount = Math.min(this.vertices.length - this.idx, count);
        do {
            count -= copyCount;
            while (copyCount > 0) {
                float x2 = spriteVertices[offset];
                float y2 = spriteVertices[offset + 1];
                this.vertices[this.idx] = t2.m00 * x2 + t2.m01 * y2 + t2.m02;
                this.vertices[this.idx + 1] = t2.m10 * x2 + t2.m11 * y2 + t2.m12;
                this.vertices[this.idx + 2] = spriteVertices[offset + 2];
                this.vertices[this.idx + 3] = spriteVertices[offset + 3];
                this.vertices[this.idx + 4] = spriteVertices[offset + 4];
                this.idx += 5;
                offset += 5;
                copyCount -= 5;
            }
            if (count <= 0) continue;
            super.flush();
            copyCount = Math.min(this.vertices.length, count);
        } while (count > 0);
    }

    private static boolean checkEqual(Matrix4 a2, Matrix4 b2) {
        if (a2 == b2) {
            return true;
        }
        return a2.val[0] == b2.val[0] && a2.val[1] == b2.val[1] && a2.val[4] == b2.val[4] && a2.val[5] == b2.val[5] && a2.val[12] == b2.val[12] && a2.val[13] == b2.val[13];
    }

    private static boolean checkEqual(Matrix4 matrix, Affine2 affine) {
        float[] val = matrix.getValues();
        return val[0] == affine.m00 && val[1] == affine.m10 && val[4] == affine.m01 && val[5] == affine.m11 && val[12] == affine.m02 && val[13] == affine.m12;
    }

    private static boolean checkIdt(Matrix4 matrix) {
        float[] val = matrix.getValues();
        return val[0] == 1.0f && val[1] == 0.0f && val[4] == 0.0f && val[5] == 1.0f && val[12] == 0.0f && val[13] == 0.0f;
    }
}

