/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders.resolvers;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;

public class ResolutionFileResolver
implements FileHandleResolver {
    protected final FileHandleResolver baseResolver;
    protected final Resolution[] descriptors;

    public ResolutionFileResolver(FileHandleResolver baseResolver, Resolution ... descriptors) {
        if (descriptors.length == 0) {
            throw new IllegalArgumentException("At least one Resolution needs to be supplied.");
        }
        this.baseResolver = baseResolver;
        this.descriptors = descriptors;
    }

    @Override
    public FileHandle resolve(String fileName) {
        Resolution bestResolution = ResolutionFileResolver.choose(this.descriptors);
        FileHandle originalHandle = new FileHandle(fileName);
        FileHandle handle = this.baseResolver.resolve(this.resolve(originalHandle, bestResolution.folder));
        if (!handle.exists()) {
            handle = this.baseResolver.resolve(fileName);
        }
        return handle;
    }

    protected String resolve(FileHandle originalHandle, String suffix) {
        String parentString = "";
        FileHandle parent = originalHandle.parent();
        if (parent != null && !parent.name().equals("")) {
            parentString = parent + "/";
        }
        return parentString + suffix + "/" + originalHandle.name();
    }

    public static Resolution choose(Resolution ... descriptors) {
        int w2 = Gdx.graphics.getBackBufferWidth();
        int h2 = Gdx.graphics.getBackBufferHeight();
        Resolution best = descriptors[0];
        if (w2 < h2) {
            int n2 = descriptors.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Resolution other = descriptors[i2];
                if (w2 < other.portraitWidth || other.portraitWidth < best.portraitWidth || h2 < other.portraitHeight || other.portraitHeight < best.portraitHeight) continue;
                best = descriptors[i2];
            }
        } else {
            int n3 = descriptors.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                Resolution other = descriptors[i3];
                if (w2 < other.portraitHeight || other.portraitHeight < best.portraitHeight || h2 < other.portraitWidth || other.portraitWidth < best.portraitWidth) continue;
                best = descriptors[i3];
            }
        }
        return best;
    }

    public static class Resolution {
        public final int portraitWidth;
        public final int portraitHeight;
        public final String folder;

        public Resolution(int portraitWidth, int portraitHeight, String folder) {
            this.portraitWidth = portraitWidth;
            this.portraitHeight = portraitHeight;
            this.folder = folder;
        }
    }
}

